/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PipelineReference
implements JsonSerializable<PipelineReference> {
    private final String type = "PipelineReference";
    private String referenceName;
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(PipelineReference.class);

    public String type() {
        return this.type;
    }

    public String referenceName() {
        return this.referenceName;
    }

    public PipelineReference withReferenceName(String referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PipelineReference withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model PipelineReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("referenceName", this.referenceName);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static PipelineReference fromJson(JsonReader jsonReader) throws IOException {
        return (PipelineReference)jsonReader.readObject(reader -> {
            PipelineReference deserializedPipelineReference = new PipelineReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("referenceName".equals(fieldName)) {
                    deserializedPipelineReference.referenceName = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPipelineReference.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPipelineReference;
        });
    }
}

