/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ParameterType;
import java.io.IOException;

public final class ParameterSpecification
implements JsonSerializable<ParameterSpecification> {
    private ParameterType type;
    private Object defaultValue;
    private static final ClientLogger LOGGER = new ClientLogger(ParameterSpecification.class);

    public ParameterType type() {
        return this.type;
    }

    public ParameterSpecification withType(ParameterType type) {
        this.type = type;
        return this;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public ParameterSpecification withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model ParameterSpecification"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeUntypedField("defaultValue", this.defaultValue);
        return jsonWriter.writeEndObject();
    }

    public static ParameterSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (ParameterSpecification)jsonReader.readObject(reader -> {
            ParameterSpecification deserializedParameterSpecification = new ParameterSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedParameterSpecification.type = ParameterType.fromString(reader.getString());
                    continue;
                }
                if ("defaultValue".equals(fieldName)) {
                    deserializedParameterSpecification.defaultValue = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedParameterSpecification;
        });
    }
}

