/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.OperationMetricAvailability;
import com.azure.resourcemanager.datafactory.models.OperationMetricDimension;
import java.io.IOException;
import java.util.List;

public final class OperationMetricSpecification
implements JsonSerializable<OperationMetricSpecification> {
    private String name;
    private String displayName;
    private String displayDescription;
    private String unit;
    private String aggregationType;
    private String enableRegionalMdmAccount;
    private String sourceMdmAccount;
    private String sourceMdmNamespace;
    private List<OperationMetricAvailability> availabilities;
    private List<OperationMetricDimension> dimensions;

    public String name() {
        return this.name;
    }

    public OperationMetricSpecification withName(String name) {
        this.name = name;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public OperationMetricSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public OperationMetricSpecification withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String unit() {
        return this.unit;
    }

    public OperationMetricSpecification withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String aggregationType() {
        return this.aggregationType;
    }

    public OperationMetricSpecification withAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public String enableRegionalMdmAccount() {
        return this.enableRegionalMdmAccount;
    }

    public OperationMetricSpecification withEnableRegionalMdmAccount(String enableRegionalMdmAccount) {
        this.enableRegionalMdmAccount = enableRegionalMdmAccount;
        return this;
    }

    public String sourceMdmAccount() {
        return this.sourceMdmAccount;
    }

    public OperationMetricSpecification withSourceMdmAccount(String sourceMdmAccount) {
        this.sourceMdmAccount = sourceMdmAccount;
        return this;
    }

    public String sourceMdmNamespace() {
        return this.sourceMdmNamespace;
    }

    public OperationMetricSpecification withSourceMdmNamespace(String sourceMdmNamespace) {
        this.sourceMdmNamespace = sourceMdmNamespace;
        return this;
    }

    public List<OperationMetricAvailability> availabilities() {
        return this.availabilities;
    }

    public OperationMetricSpecification withAvailabilities(List<OperationMetricAvailability> availabilities) {
        this.availabilities = availabilities;
        return this;
    }

    public List<OperationMetricDimension> dimensions() {
        return this.dimensions;
    }

    public OperationMetricSpecification withDimensions(List<OperationMetricDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public void validate() {
        if (this.availabilities() != null) {
            this.availabilities().forEach(e -> e.validate());
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("aggregationType", this.aggregationType);
        jsonWriter.writeStringField("enableRegionalMdmAccount", this.enableRegionalMdmAccount);
        jsonWriter.writeStringField("sourceMdmAccount", this.sourceMdmAccount);
        jsonWriter.writeStringField("sourceMdmNamespace", this.sourceMdmNamespace);
        jsonWriter.writeArrayField("availabilities", this.availabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static OperationMetricSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (OperationMetricSpecification)jsonReader.readObject(reader -> {
            OperationMetricSpecification deserializedOperationMetricSpecification = new OperationMetricSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationMetricSpecification.name = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedOperationMetricSpecification.displayName = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedOperationMetricSpecification.displayDescription = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedOperationMetricSpecification.unit = reader.getString();
                    continue;
                }
                if ("aggregationType".equals(fieldName)) {
                    deserializedOperationMetricSpecification.aggregationType = reader.getString();
                    continue;
                }
                if ("enableRegionalMdmAccount".equals(fieldName)) {
                    deserializedOperationMetricSpecification.enableRegionalMdmAccount = reader.getString();
                    continue;
                }
                if ("sourceMdmAccount".equals(fieldName)) {
                    deserializedOperationMetricSpecification.sourceMdmAccount = reader.getString();
                    continue;
                }
                if ("sourceMdmNamespace".equals(fieldName)) {
                    deserializedOperationMetricSpecification.sourceMdmNamespace = reader.getString();
                    continue;
                }
                if ("availabilities".equals(fieldName)) {
                    List availabilities;
                    deserializedOperationMetricSpecification.availabilities = availabilities = reader.readArray(reader1 -> OperationMetricAvailability.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedOperationMetricSpecification.dimensions = dimensions = reader.readArray(reader1 -> OperationMetricDimension.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationMetricSpecification;
        });
    }
}

