/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MapperPolicyRecurrence;
import java.io.IOException;

public final class MapperPolicy
implements JsonSerializable<MapperPolicy> {
    private String mode;
    private MapperPolicyRecurrence recurrence;

    public String mode() {
        return this.mode;
    }

    public MapperPolicy withMode(String mode) {
        this.mode = mode;
        return this;
    }

    public MapperPolicyRecurrence recurrence() {
        return this.recurrence;
    }

    public MapperPolicy withRecurrence(MapperPolicyRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public void validate() {
        if (this.recurrence() != null) {
            this.recurrence().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode);
        jsonWriter.writeJsonField("recurrence", (JsonSerializable)this.recurrence);
        return jsonWriter.writeEndObject();
    }

    public static MapperPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (MapperPolicy)jsonReader.readObject(reader -> {
            MapperPolicy deserializedMapperPolicy = new MapperPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedMapperPolicy.mode = reader.getString();
                    continue;
                }
                if ("recurrence".equals(fieldName)) {
                    deserializedMapperPolicy.recurrence = MapperPolicyRecurrence.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapperPolicy;
        });
    }
}

