/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedVirtualNetworkResourceInner;
import java.io.IOException;
import java.util.List;

public final class ManagedVirtualNetworkListResponse
implements JsonSerializable<ManagedVirtualNetworkListResponse> {
    private List<ManagedVirtualNetworkResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedVirtualNetworkListResponse.class);

    public List<ManagedVirtualNetworkResourceInner> value() {
        return this.value;
    }

    public ManagedVirtualNetworkListResponse withValue(List<ManagedVirtualNetworkResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ManagedVirtualNetworkListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ManagedVirtualNetworkListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ManagedVirtualNetworkListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedVirtualNetworkListResponse)jsonReader.readObject(reader -> {
            ManagedVirtualNetworkListResponse deserializedManagedVirtualNetworkListResponse = new ManagedVirtualNetworkListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedManagedVirtualNetworkListResponse.value = value = reader.readArray(reader1 -> ManagedVirtualNetworkResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedManagedVirtualNetworkListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedVirtualNetworkListResponse;
        });
    }
}

