/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.SubResourceDebugResource;
import java.io.IOException;

public final class LinkedServiceDebugResource
extends SubResourceDebugResource {
    private LinkedService properties;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedServiceDebugResource.class);

    public LinkedService properties() {
        return this.properties;
    }

    public LinkedServiceDebugResource withProperties(LinkedService properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public LinkedServiceDebugResource withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model LinkedServiceDebugResource"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static LinkedServiceDebugResource fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedServiceDebugResource)jsonReader.readObject(reader -> {
            LinkedServiceDebugResource deserializedLinkedServiceDebugResource = new LinkedServiceDebugResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedLinkedServiceDebugResource.withName(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedLinkedServiceDebugResource.properties = LinkedService.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedServiceDebugResource;
        });
    }
}

