/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LakeHouseTableSource
extends CopySource {
    private String type = "LakeHouseTableSource";
    private Object timestampAsOf;
    private Object versionAsOf;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object timestampAsOf() {
        return this.timestampAsOf;
    }

    public LakeHouseTableSource withTimestampAsOf(Object timestampAsOf) {
        this.timestampAsOf = timestampAsOf;
        return this;
    }

    public Object versionAsOf() {
        return this.versionAsOf;
    }

    public LakeHouseTableSource withVersionAsOf(Object versionAsOf) {
        this.versionAsOf = versionAsOf;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public LakeHouseTableSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public LakeHouseTableSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public LakeHouseTableSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public LakeHouseTableSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public LakeHouseTableSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("timestampAsOf", this.timestampAsOf);
        jsonWriter.writeUntypedField("versionAsOf", this.versionAsOf);
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LakeHouseTableSource fromJson(JsonReader jsonReader) throws IOException {
        return (LakeHouseTableSource)jsonReader.readObject(reader -> {
            LakeHouseTableSource deserializedLakeHouseTableSource = new LakeHouseTableSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedLakeHouseTableSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedLakeHouseTableSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedLakeHouseTableSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedLakeHouseTableSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLakeHouseTableSource.type = reader.getString();
                    continue;
                }
                if ("timestampAsOf".equals(fieldName)) {
                    deserializedLakeHouseTableSource.timestampAsOf = reader.readUntyped();
                    continue;
                }
                if ("versionAsOf".equals(fieldName)) {
                    deserializedLakeHouseTableSource.versionAsOf = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedLakeHouseTableSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedLakeHouseTableSource.withAdditionalProperties(additionalProperties);
            return deserializedLakeHouseTableSource;
        });
    }
}

