/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.SelfHostedIntegrationRuntime;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class IntegrationRuntime
implements JsonSerializable<IntegrationRuntime> {
    private IntegrationRuntimeType type = IntegrationRuntimeType.fromString("IntegrationRuntime");
    private String description;
    private Map<String, Object> additionalProperties;

    public IntegrationRuntimeType type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public IntegrationRuntime withDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntime withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("description", this.description);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntime fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntime)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                IntegrationRuntime integrationRuntime;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Managed".equals(discriminatorValue)) {
                    integrationRuntime = ManagedIntegrationRuntime.fromJson(readerToUse.reset());
                    return integrationRuntime;
                }
                if ("SelfHosted".equals(discriminatorValue)) {
                    integrationRuntime = SelfHostedIntegrationRuntime.fromJson(readerToUse.reset());
                    return integrationRuntime;
                }
                integrationRuntime = IntegrationRuntime.fromJsonKnownDiscriminator(readerToUse.reset());
                return integrationRuntime;
            }
        });
    }

    static IntegrationRuntime fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntime)jsonReader.readObject(reader -> {
            IntegrationRuntime deserializedIntegrationRuntime = new IntegrationRuntime();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedIntegrationRuntime.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIntegrationRuntime.description = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntime.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntime;
        });
    }
}

