/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.IfConditionActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IfConditionActivity
extends ControlActivity {
    private String type = "IfCondition";
    private IfConditionActivityTypeProperties innerTypeProperties = new IfConditionActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(IfConditionActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    IfConditionActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public IfConditionActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public IfConditionActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public IfConditionActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public IfConditionActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public IfConditionActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public IfConditionActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Expression expression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().expression();
    }

    public IfConditionActivity withExpression(Expression expression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new IfConditionActivityTypeProperties();
        }
        this.innerTypeProperties().withExpression(expression);
        return this;
    }

    public List<Activity> ifTrueActivities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ifTrueActivities();
    }

    public IfConditionActivity withIfTrueActivities(List<Activity> ifTrueActivities) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new IfConditionActivityTypeProperties();
        }
        this.innerTypeProperties().withIfTrueActivities(ifTrueActivities);
        return this;
    }

    public List<Activity> ifFalseActivities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().ifFalseActivities();
    }

    public IfConditionActivity withIfFalseActivities(List<Activity> ifFalseActivities) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new IfConditionActivityTypeProperties();
        }
        this.innerTypeProperties().withIfFalseActivities(ifFalseActivities);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model IfConditionActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model IfConditionActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IfConditionActivity fromJson(JsonReader jsonReader) throws IOException {
        return (IfConditionActivity)jsonReader.readObject(reader -> {
            IfConditionActivity deserializedIfConditionActivity = new IfConditionActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIfConditionActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIfConditionActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedIfConditionActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedIfConditionActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedIfConditionActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedIfConditionActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedIfConditionActivity.innerTypeProperties = IfConditionActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIfConditionActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIfConditionActivity.withAdditionalProperties(additionalProperties);
            return deserializedIfConditionActivity;
        });
    }
}

