/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.GlobalParameterType;
import java.io.IOException;

public final class GlobalParameterSpecification
implements JsonSerializable<GlobalParameterSpecification> {
    private GlobalParameterType type;
    private Object value;
    private static final ClientLogger LOGGER = new ClientLogger(GlobalParameterSpecification.class);

    public GlobalParameterType type() {
        return this.type;
    }

    public GlobalParameterSpecification withType(GlobalParameterType type) {
        this.type = type;
        return this;
    }

    public Object value() {
        return this.value;
    }

    public GlobalParameterSpecification withValue(Object value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model GlobalParameterSpecification"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model GlobalParameterSpecification"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeUntypedField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static GlobalParameterSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (GlobalParameterSpecification)jsonReader.readObject(reader -> {
            GlobalParameterSpecification deserializedGlobalParameterSpecification = new GlobalParameterSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedGlobalParameterSpecification.type = GlobalParameterType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedGlobalParameterSpecification.value = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGlobalParameterSpecification;
        });
    }
}

