/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.GetMetadataActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.FormatReadSettings;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class GetMetadataActivity
extends ExecutionActivity {
    private String type = "GetMetadata";
    private GetMetadataActivityTypeProperties innerTypeProperties = new GetMetadataActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(GetMetadataActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    GetMetadataActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public GetMetadataActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public GetMetadataActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public GetMetadataActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public GetMetadataActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public GetMetadataActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public GetMetadataActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public GetMetadataActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public GetMetadataActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public DatasetReference dataset() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataset();
    }

    public GetMetadataActivity withDataset(DatasetReference dataset) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withDataset(dataset);
        return this;
    }

    public List<Object> fieldList() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fieldList();
    }

    public GetMetadataActivity withFieldList(List<Object> fieldList) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withFieldList(fieldList);
        return this;
    }

    public StoreReadSettings storeSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storeSettings();
    }

    public GetMetadataActivity withStoreSettings(StoreReadSettings storeSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withStoreSettings(storeSettings);
        return this;
    }

    public FormatReadSettings formatSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().formatSettings();
    }

    public GetMetadataActivity withFormatSettings(FormatReadSettings formatSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new GetMetadataActivityTypeProperties();
        }
        this.innerTypeProperties().withFormatSettings(formatSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model GetMetadataActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model GetMetadataActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static GetMetadataActivity fromJson(JsonReader jsonReader) throws IOException {
        return (GetMetadataActivity)jsonReader.readObject(reader -> {
            GetMetadataActivity deserializedGetMetadataActivity = new GetMetadataActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGetMetadataActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGetMetadataActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedGetMetadataActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedGetMetadataActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedGetMetadataActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedGetMetadataActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedGetMetadataActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedGetMetadataActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedGetMetadataActivity.innerTypeProperties = GetMetadataActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGetMetadataActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedGetMetadataActivity.withAdditionalProperties(additionalProperties);
            return deserializedGetMetadataActivity;
        });
    }
}

