/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FactoryGitHubConfiguration;
import com.azure.resourcemanager.datafactory.models.FactoryVstsConfiguration;
import java.io.IOException;

public class FactoryRepoConfiguration
implements JsonSerializable<FactoryRepoConfiguration> {
    private String type = "FactoryRepoConfiguration";
    private String accountName;
    private String repositoryName;
    private String collaborationBranch;
    private String rootFolder;
    private String lastCommitId;
    private Boolean disablePublish;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryRepoConfiguration.class);

    public String type() {
        return this.type;
    }

    public String accountName() {
        return this.accountName;
    }

    public FactoryRepoConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public FactoryRepoConfiguration withRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public String collaborationBranch() {
        return this.collaborationBranch;
    }

    public FactoryRepoConfiguration withCollaborationBranch(String collaborationBranch) {
        this.collaborationBranch = collaborationBranch;
        return this;
    }

    public String rootFolder() {
        return this.rootFolder;
    }

    public FactoryRepoConfiguration withRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
        return this;
    }

    public String lastCommitId() {
        return this.lastCommitId;
    }

    public FactoryRepoConfiguration withLastCommitId(String lastCommitId) {
        this.lastCommitId = lastCommitId;
        return this;
    }

    public Boolean disablePublish() {
        return this.disablePublish;
    }

    public FactoryRepoConfiguration withDisablePublish(Boolean disablePublish) {
        this.disablePublish = disablePublish;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model FactoryRepoConfiguration"));
        }
        if (this.repositoryName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property repositoryName in model FactoryRepoConfiguration"));
        }
        if (this.collaborationBranch() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property collaborationBranch in model FactoryRepoConfiguration"));
        }
        if (this.rootFolder() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rootFolder in model FactoryRepoConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("repositoryName", this.repositoryName);
        jsonWriter.writeStringField("collaborationBranch", this.collaborationBranch);
        jsonWriter.writeStringField("rootFolder", this.rootFolder);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("lastCommitId", this.lastCommitId);
        jsonWriter.writeBooleanField("disablePublish", this.disablePublish);
        return jsonWriter.writeEndObject();
    }

    public static FactoryRepoConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryRepoConfiguration)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                FactoryRepoConfiguration factoryRepoConfiguration;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("FactoryVSTSConfiguration".equals(discriminatorValue)) {
                    factoryRepoConfiguration = FactoryVstsConfiguration.fromJson(readerToUse.reset());
                    return factoryRepoConfiguration;
                }
                if ("FactoryGitHubConfiguration".equals(discriminatorValue)) {
                    factoryRepoConfiguration = FactoryGitHubConfiguration.fromJson(readerToUse.reset());
                    return factoryRepoConfiguration;
                }
                factoryRepoConfiguration = FactoryRepoConfiguration.fromJsonKnownDiscriminator(readerToUse.reset());
                return factoryRepoConfiguration;
            }
        });
    }

    static FactoryRepoConfiguration fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (FactoryRepoConfiguration)jsonReader.readObject(reader -> {
            FactoryRepoConfiguration deserializedFactoryRepoConfiguration = new FactoryRepoConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.accountName = reader.getString();
                    continue;
                }
                if ("repositoryName".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.repositoryName = reader.getString();
                    continue;
                }
                if ("collaborationBranch".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.collaborationBranch = reader.getString();
                    continue;
                }
                if ("rootFolder".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.rootFolder = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.type = reader.getString();
                    continue;
                }
                if ("lastCommitId".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.lastCommitId = reader.getString();
                    continue;
                }
                if ("disablePublish".equals(fieldName)) {
                    deserializedFactoryRepoConfiguration.disablePublish = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryRepoConfiguration;
        });
    }
}

