/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.FactoryIdentityType;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class FactoryIdentity
implements JsonSerializable<FactoryIdentity> {
    private FactoryIdentityType type;
    private UUID principalId;
    private UUID tenantId;
    private Map<String, Object> userAssignedIdentities;
    private static final ClientLogger LOGGER = new ClientLogger(FactoryIdentity.class);

    public FactoryIdentityType type() {
        return this.type;
    }

    public FactoryIdentity withType(FactoryIdentityType type) {
        this.type = type;
        return this;
    }

    public UUID principalId() {
        return this.principalId;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public Map<String, Object> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public FactoryIdentity withUserAssignedIdentities(Map<String, Object> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model FactoryIdentity"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static FactoryIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (FactoryIdentity)jsonReader.readObject(reader -> {
            FactoryIdentity deserializedFactoryIdentity = new FactoryIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedFactoryIdentity.type = FactoryIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedFactoryIdentity.principalId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedFactoryIdentity.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedFactoryIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFactoryIdentity;
        });
    }
}

