/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ExecutePowerQueryActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ContinuationSettingsReference;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DataFlowStagingInfo;
import com.azure.resourcemanager.datafactory.models.ExecuteDataFlowActivityTypePropertiesCompute;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.PowerQuerySink;
import com.azure.resourcemanager.datafactory.models.PowerQuerySinkMapping;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExecuteWranglingDataflowActivity
extends Activity {
    private String type = "ExecuteWranglingDataflow";
    private ExecutePowerQueryActivityTypeProperties innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
    private ActivityPolicy policy;
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteWranglingDataflowActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    ExecutePowerQueryActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public ActivityPolicy policy() {
        return this.policy;
    }

    public ExecuteWranglingDataflowActivity withPolicy(ActivityPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public ExecuteWranglingDataflowActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecuteWranglingDataflowActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecuteWranglingDataflowActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ExecuteWranglingDataflowActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecuteWranglingDataflowActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn(dependsOn);
        return this;
    }

    @Override
    public ExecuteWranglingDataflowActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties(userProperties);
        return this;
    }

    public Map<String, PowerQuerySink> sinks() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sinks();
    }

    public ExecuteWranglingDataflowActivity withSinks(Map<String, PowerQuerySink> sinks) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withSinks(sinks);
        return this;
    }

    public List<PowerQuerySinkMapping> queries() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().queries();
    }

    public ExecuteWranglingDataflowActivity withQueries(List<PowerQuerySinkMapping> queries) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withQueries(queries);
        return this;
    }

    public DataFlowReference dataFlow() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataFlow();
    }

    public ExecuteWranglingDataflowActivity withDataFlow(DataFlowReference dataFlow) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withDataFlow(dataFlow);
        return this;
    }

    public DataFlowStagingInfo staging() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().staging();
    }

    public ExecuteWranglingDataflowActivity withStaging(DataFlowStagingInfo staging) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withStaging(staging);
        return this;
    }

    public IntegrationRuntimeReference integrationRuntime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().integrationRuntime();
    }

    public ExecuteWranglingDataflowActivity withIntegrationRuntime(IntegrationRuntimeReference integrationRuntime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withIntegrationRuntime(integrationRuntime);
        return this;
    }

    public ContinuationSettingsReference continuationSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().continuationSettings();
    }

    public ExecuteWranglingDataflowActivity withContinuationSettings(ContinuationSettingsReference continuationSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withContinuationSettings(continuationSettings);
        return this;
    }

    public ExecuteDataFlowActivityTypePropertiesCompute compute() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compute();
    }

    public ExecuteWranglingDataflowActivity withCompute(ExecuteDataFlowActivityTypePropertiesCompute compute) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withCompute(compute);
        return this;
    }

    public Object traceLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().traceLevel();
    }

    public ExecuteWranglingDataflowActivity withTraceLevel(Object traceLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withTraceLevel(traceLevel);
        return this;
    }

    public Object continueOnError() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().continueOnError();
    }

    public ExecuteWranglingDataflowActivity withContinueOnError(Object continueOnError) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withContinueOnError(continueOnError);
        return this;
    }

    public Object runConcurrently() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runConcurrently();
    }

    public ExecuteWranglingDataflowActivity withRunConcurrently(Object runConcurrently) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withRunConcurrently(runConcurrently);
        return this;
    }

    public Object sourceStagingConcurrency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sourceStagingConcurrency();
    }

    public ExecuteWranglingDataflowActivity withSourceStagingConcurrency(Object sourceStagingConcurrency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecutePowerQueryActivityTypeProperties();
        }
        this.innerTypeProperties().withSourceStagingConcurrency(sourceStagingConcurrency);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ExecuteWranglingDataflowActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.policy() != null) {
            this.policy().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExecuteWranglingDataflowActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecuteWranglingDataflowActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteWranglingDataflowActivity)jsonReader.readObject(reader -> {
            ExecuteWranglingDataflowActivity deserializedExecuteWranglingDataflowActivity = new ExecuteWranglingDataflowActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecuteWranglingDataflowActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecuteWranglingDataflowActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.innerTypeProperties = ExecutePowerQueryActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.type = reader.getString();
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecuteWranglingDataflowActivity.policy = ActivityPolicy.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecuteWranglingDataflowActivity.withAdditionalProperties(additionalProperties);
            return deserializedExecuteWranglingDataflowActivity;
        });
    }
}

