/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ExecuteSsisPackageActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SsisExecutionCredential;
import com.azure.resourcemanager.datafactory.models.SsisExecutionParameter;
import com.azure.resourcemanager.datafactory.models.SsisLogLocation;
import com.azure.resourcemanager.datafactory.models.SsisPackageLocation;
import com.azure.resourcemanager.datafactory.models.SsisPropertyOverride;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExecuteSsisPackageActivity
extends ExecutionActivity {
    private String type = "ExecuteSSISPackage";
    private ExecuteSsisPackageActivityTypeProperties innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ExecuteSsisPackageActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    ExecuteSsisPackageActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ExecuteSsisPackageActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ExecuteSsisPackageActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public SsisPackageLocation packageLocation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageLocation();
    }

    public ExecuteSsisPackageActivity withPackageLocation(SsisPackageLocation packageLocation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPackageLocation(packageLocation);
        return this;
    }

    public Object runtime() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().runtime();
    }

    public ExecuteSsisPackageActivity withRuntime(Object runtime) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withRuntime(runtime);
        return this;
    }

    public Object loggingLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loggingLevel();
    }

    public ExecuteSsisPackageActivity withLoggingLevel(Object loggingLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withLoggingLevel(loggingLevel);
        return this;
    }

    public Object environmentPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().environmentPath();
    }

    public ExecuteSsisPackageActivity withEnvironmentPath(Object environmentPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withEnvironmentPath(environmentPath);
        return this;
    }

    public SsisExecutionCredential executionCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().executionCredential();
    }

    public ExecuteSsisPackageActivity withExecutionCredential(SsisExecutionCredential executionCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withExecutionCredential(executionCredential);
        return this;
    }

    public IntegrationRuntimeReference connectVia() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectVia();
    }

    public ExecuteSsisPackageActivity withConnectVia(IntegrationRuntimeReference connectVia) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withConnectVia(connectVia);
        return this;
    }

    public Map<String, SsisExecutionParameter> projectParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().projectParameters();
    }

    public ExecuteSsisPackageActivity withProjectParameters(Map<String, SsisExecutionParameter> projectParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withProjectParameters(projectParameters);
        return this;
    }

    public Map<String, SsisExecutionParameter> packageParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageParameters();
    }

    public ExecuteSsisPackageActivity withPackageParameters(Map<String, SsisExecutionParameter> packageParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPackageParameters(packageParameters);
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().projectConnectionManagers();
    }

    public ExecuteSsisPackageActivity withProjectConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> projectConnectionManagers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withProjectConnectionManagers(projectConnectionManagers);
        return this;
    }

    public Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packageConnectionManagers();
    }

    public ExecuteSsisPackageActivity withPackageConnectionManagers(Map<String, Map<String, SsisExecutionParameter>> packageConnectionManagers) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPackageConnectionManagers(packageConnectionManagers);
        return this;
    }

    public Map<String, SsisPropertyOverride> propertyOverrides() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().propertyOverrides();
    }

    public ExecuteSsisPackageActivity withPropertyOverrides(Map<String, SsisPropertyOverride> propertyOverrides) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withPropertyOverrides(propertyOverrides);
        return this;
    }

    public SsisLogLocation logLocation() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logLocation();
    }

    public ExecuteSsisPackageActivity withLogLocation(SsisLogLocation logLocation) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExecuteSsisPackageActivityTypeProperties();
        }
        this.innerTypeProperties().withLogLocation(logLocation);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ExecuteSsisPackageActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ExecuteSsisPackageActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExecuteSsisPackageActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ExecuteSsisPackageActivity)jsonReader.readObject(reader -> {
            ExecuteSsisPackageActivity deserializedExecuteSsisPackageActivity = new ExecuteSsisPackageActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedExecuteSsisPackageActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedExecuteSsisPackageActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.innerTypeProperties = ExecuteSsisPackageActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecuteSsisPackageActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExecuteSsisPackageActivity.withAdditionalProperties(additionalProperties);
            return deserializedExecuteSsisPackageActivity;
        });
    }
}

