/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ExcelDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ExcelDataset
extends Dataset {
    private String type = "Excel";
    private ExcelDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ExcelDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    ExcelDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ExcelDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ExcelDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public ExcelDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public ExcelDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ExcelDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public ExcelDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public ExcelDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    public ExcelDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    public Object sheetName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sheetName();
    }

    public ExcelDataset withSheetName(Object sheetName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withSheetName(sheetName);
        return this;
    }

    public Object sheetIndex() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sheetIndex();
    }

    public ExcelDataset withSheetIndex(Object sheetIndex) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withSheetIndex(sheetIndex);
        return this;
    }

    public Object range() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().range();
    }

    public ExcelDataset withRange(Object range) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withRange(range);
        return this;
    }

    public Object firstRowAsHeader() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().firstRowAsHeader();
    }

    public ExcelDataset withFirstRowAsHeader(Object firstRowAsHeader) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withFirstRowAsHeader(firstRowAsHeader);
        return this;
    }

    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    public ExcelDataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    public Object nullValue() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nullValue();
    }

    public ExcelDataset withNullValue(Object nullValue) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ExcelDatasetTypeProperties();
        }
        this.innerTypeProperties().withNullValue(nullValue);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model ExcelDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ExcelDataset fromJson(JsonReader jsonReader) throws IOException {
        return (ExcelDataset)jsonReader.readObject(reader -> {
            ExcelDataset deserializedExcelDataset = new ExcelDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedExcelDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedExcelDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedExcelDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedExcelDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedExcelDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedExcelDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedExcelDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExcelDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedExcelDataset.innerTypeProperties = ExcelDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedExcelDataset.withAdditionalProperties(additionalProperties);
            return deserializedExcelDataset;
        });
    }
}

