/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.DynamicsSinkWriteBehavior;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DynamicsSink
extends CopySink {
    private String type = "DynamicsSink";
    private DynamicsSinkWriteBehavior writeBehavior;
    private Object ignoreNullValues;
    private Object alternateKeyName;
    private Object bypassBusinessLogicExecution;
    private Object bypassPowerAutomateFlows;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicsSink.class);

    @Override
    public String type() {
        return this.type;
    }

    public DynamicsSinkWriteBehavior writeBehavior() {
        return this.writeBehavior;
    }

    public DynamicsSink withWriteBehavior(DynamicsSinkWriteBehavior writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    public Object ignoreNullValues() {
        return this.ignoreNullValues;
    }

    public DynamicsSink withIgnoreNullValues(Object ignoreNullValues) {
        this.ignoreNullValues = ignoreNullValues;
        return this;
    }

    public Object alternateKeyName() {
        return this.alternateKeyName;
    }

    public DynamicsSink withAlternateKeyName(Object alternateKeyName) {
        this.alternateKeyName = alternateKeyName;
        return this;
    }

    public Object bypassBusinessLogicExecution() {
        return this.bypassBusinessLogicExecution;
    }

    public DynamicsSink withBypassBusinessLogicExecution(Object bypassBusinessLogicExecution) {
        this.bypassBusinessLogicExecution = bypassBusinessLogicExecution;
        return this;
    }

    public Object bypassPowerAutomateFlows() {
        return this.bypassPowerAutomateFlows;
    }

    public DynamicsSink withBypassPowerAutomateFlows(Object bypassPowerAutomateFlows) {
        this.bypassPowerAutomateFlows = bypassPowerAutomateFlows;
        return this;
    }

    @Override
    public DynamicsSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public DynamicsSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public DynamicsSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public DynamicsSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public DynamicsSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public DynamicsSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.writeBehavior() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property writeBehavior in model DynamicsSink"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("writeBehavior", this.writeBehavior == null ? null : this.writeBehavior.toString());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("ignoreNullValues", this.ignoreNullValues);
        jsonWriter.writeUntypedField("alternateKeyName", this.alternateKeyName);
        jsonWriter.writeUntypedField("bypassBusinessLogicExecution", this.bypassBusinessLogicExecution);
        jsonWriter.writeUntypedField("bypassPowerAutomateFlows", this.bypassPowerAutomateFlows);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DynamicsSink fromJson(JsonReader jsonReader) throws IOException {
        return (DynamicsSink)jsonReader.readObject(reader -> {
            DynamicsSink deserializedDynamicsSink = new DynamicsSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedDynamicsSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedDynamicsSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedDynamicsSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedDynamicsSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedDynamicsSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedDynamicsSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedDynamicsSink.writeBehavior = DynamicsSinkWriteBehavior.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDynamicsSink.type = reader.getString();
                    continue;
                }
                if ("ignoreNullValues".equals(fieldName)) {
                    deserializedDynamicsSink.ignoreNullValues = reader.readUntyped();
                    continue;
                }
                if ("alternateKeyName".equals(fieldName)) {
                    deserializedDynamicsSink.alternateKeyName = reader.readUntyped();
                    continue;
                }
                if ("bypassBusinessLogicExecution".equals(fieldName)) {
                    deserializedDynamicsSink.bypassBusinessLogicExecution = reader.readUntyped();
                    continue;
                }
                if ("bypassPowerAutomateFlows".equals(fieldName)) {
                    deserializedDynamicsSink.bypassPowerAutomateFlows = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDynamicsSink.withAdditionalProperties(additionalProperties);
            return deserializedDynamicsSink;
        });
    }
}

