/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.DelimitedTextDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DelimitedTextDataset
extends Dataset {
    private String type = "DelimitedText";
    private DelimitedTextDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DelimitedTextDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    DelimitedTextDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public DelimitedTextDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DelimitedTextDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public DelimitedTextDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public DelimitedTextDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public DelimitedTextDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public DelimitedTextDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public DelimitedTextDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public DatasetLocation location() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().location();
    }

    public DelimitedTextDataset withLocation(DatasetLocation location) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withLocation(location);
        return this;
    }

    public Object columnDelimiter() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().columnDelimiter();
    }

    public DelimitedTextDataset withColumnDelimiter(Object columnDelimiter) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withColumnDelimiter(columnDelimiter);
        return this;
    }

    public Object rowDelimiter() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().rowDelimiter();
    }

    public DelimitedTextDataset withRowDelimiter(Object rowDelimiter) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withRowDelimiter(rowDelimiter);
        return this;
    }

    public Object encodingName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encodingName();
    }

    public DelimitedTextDataset withEncodingName(Object encodingName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withEncodingName(encodingName);
        return this;
    }

    public Object compressionCodec() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compressionCodec();
    }

    public DelimitedTextDataset withCompressionCodec(Object compressionCodec) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompressionCodec(compressionCodec);
        return this;
    }

    public Object compressionLevel() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compressionLevel();
    }

    public DelimitedTextDataset withCompressionLevel(Object compressionLevel) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompressionLevel(compressionLevel);
        return this;
    }

    public Object quoteChar() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().quoteChar();
    }

    public DelimitedTextDataset withQuoteChar(Object quoteChar) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withQuoteChar(quoteChar);
        return this;
    }

    public Object escapeChar() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().escapeChar();
    }

    public DelimitedTextDataset withEscapeChar(Object escapeChar) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withEscapeChar(escapeChar);
        return this;
    }

    public Object firstRowAsHeader() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().firstRowAsHeader();
    }

    public DelimitedTextDataset withFirstRowAsHeader(Object firstRowAsHeader) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withFirstRowAsHeader(firstRowAsHeader);
        return this;
    }

    public Object nullValue() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().nullValue();
    }

    public DelimitedTextDataset withNullValue(Object nullValue) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new DelimitedTextDatasetTypeProperties();
        }
        this.innerTypeProperties().withNullValue(nullValue);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model DelimitedTextDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DelimitedTextDataset fromJson(JsonReader jsonReader) throws IOException {
        return (DelimitedTextDataset)jsonReader.readObject(reader -> {
            DelimitedTextDataset deserializedDelimitedTextDataset = new DelimitedTextDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedDelimitedTextDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDelimitedTextDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedDelimitedTextDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedDelimitedTextDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedDelimitedTextDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedDelimitedTextDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedDelimitedTextDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDelimitedTextDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedDelimitedTextDataset.innerTypeProperties = DelimitedTextDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDelimitedTextDataset.withAdditionalProperties(additionalProperties);
            return deserializedDelimitedTextDataset;
        });
    }
}

