/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public final class DataFlowStagingInfo
implements JsonSerializable<DataFlowStagingInfo> {
    private LinkedServiceReference linkedService;
    private Object folderPath;

    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    public DataFlowStagingInfo withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    public Object folderPath() {
        return this.folderPath;
    }

    public DataFlowStagingInfo withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public void validate() {
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService);
        jsonWriter.writeUntypedField("folderPath", this.folderPath);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowStagingInfo fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowStagingInfo)jsonReader.readObject(reader -> {
            DataFlowStagingInfo deserializedDataFlowStagingInfo = new DataFlowStagingInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedService".equals(fieldName)) {
                    deserializedDataFlowStagingInfo.linkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    deserializedDataFlowStagingInfo.folderPath = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowStagingInfo;
        });
    }
}

