/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.Transformation;
import java.io.IOException;

public class DataFlowSource
extends Transformation {
    private LinkedServiceReference schemaLinkedService;
    private static final ClientLogger LOGGER = new ClientLogger(DataFlowSource.class);

    public LinkedServiceReference schemaLinkedService() {
        return this.schemaLinkedService;
    }

    public DataFlowSource withSchemaLinkedService(LinkedServiceReference schemaLinkedService) {
        this.schemaLinkedService = schemaLinkedService;
        return this;
    }

    @Override
    public DataFlowSource withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DataFlowSource withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DataFlowSource withDataset(DatasetReference dataset) {
        super.withDataset(dataset);
        return this;
    }

    @Override
    public DataFlowSource withLinkedService(LinkedServiceReference linkedService) {
        super.withLinkedService(linkedService);
        return this;
    }

    @Override
    public DataFlowSource withFlowlet(DataFlowReference flowlet) {
        super.withFlowlet(flowlet);
        return this;
    }

    @Override
    public void validate() {
        if (this.schemaLinkedService() != null) {
            this.schemaLinkedService().validate();
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model DataFlowSource"));
        }
        if (this.dataset() != null) {
            this.dataset().validate();
        }
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.flowlet() != null) {
            this.flowlet().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset());
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService());
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.flowlet());
        jsonWriter.writeJsonField("schemaLinkedService", (JsonSerializable)this.schemaLinkedService);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowSource fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowSource)jsonReader.readObject(reader -> {
            DataFlowSource deserializedDataFlowSource = new DataFlowSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDataFlowSource.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDataFlowSource.withDescription(reader.getString());
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedDataFlowSource.withDataset(DatasetReference.fromJson(reader));
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedDataFlowSource.withLinkedService(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedDataFlowSource.withFlowlet(DataFlowReference.fromJson(reader));
                    continue;
                }
                if ("schemaLinkedService".equals(fieldName)) {
                    deserializedDataFlowSource.schemaLinkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowSource;
        });
    }
}

