/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugCommandPayload;
import com.azure.resourcemanager.datafactory.models.DataFlowDebugCommandType;
import java.io.IOException;

public final class DataFlowDebugCommandRequest
implements JsonSerializable<DataFlowDebugCommandRequest> {
    private String sessionId;
    private DataFlowDebugCommandType command;
    private DataFlowDebugCommandPayload commandPayload;

    public String sessionId() {
        return this.sessionId;
    }

    public DataFlowDebugCommandRequest withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public DataFlowDebugCommandType command() {
        return this.command;
    }

    public DataFlowDebugCommandRequest withCommand(DataFlowDebugCommandType command) {
        this.command = command;
        return this;
    }

    public DataFlowDebugCommandPayload commandPayload() {
        return this.commandPayload;
    }

    public DataFlowDebugCommandRequest withCommandPayload(DataFlowDebugCommandPayload commandPayload) {
        this.commandPayload = commandPayload;
        return this;
    }

    public void validate() {
        if (this.commandPayload() != null) {
            this.commandPayload().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sessionId", this.sessionId);
        jsonWriter.writeStringField("command", this.command == null ? null : this.command.toString());
        jsonWriter.writeJsonField("commandPayload", (JsonSerializable)this.commandPayload);
        return jsonWriter.writeEndObject();
    }

    public static DataFlowDebugCommandRequest fromJson(JsonReader jsonReader) throws IOException {
        return (DataFlowDebugCommandRequest)jsonReader.readObject(reader -> {
            DataFlowDebugCommandRequest deserializedDataFlowDebugCommandRequest = new DataFlowDebugCommandRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sessionId".equals(fieldName)) {
                    deserializedDataFlowDebugCommandRequest.sessionId = reader.getString();
                    continue;
                }
                if ("command".equals(fieldName)) {
                    deserializedDataFlowDebugCommandRequest.command = DataFlowDebugCommandType.fromString(reader.getString());
                    continue;
                }
                if ("commandPayload".equals(fieldName)) {
                    deserializedDataFlowDebugCommandRequest.commandPayload = DataFlowDebugCommandPayload.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataFlowDebugCommandRequest;
        });
    }
}

