/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.CredentialResourceInner;
import java.io.IOException;
import java.util.List;

public final class CredentialListResponse
implements JsonSerializable<CredentialListResponse> {
    private List<CredentialResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CredentialListResponse.class);

    public List<CredentialResourceInner> value() {
        return this.value;
    }

    public CredentialListResponse withValue(List<CredentialResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public CredentialListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CredentialListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CredentialListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialListResponse)jsonReader.readObject(reader -> {
            CredentialListResponse deserializedCredentialListResponse = new CredentialListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCredentialListResponse.value = value = reader.readArray(reader1 -> CredentialResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCredentialListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialListResponse;
        });
    }
}

