/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ManagedIdentityCredential;
import com.azure.resourcemanager.datafactory.models.ServicePrincipalCredential;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Credential
implements JsonSerializable<Credential> {
    private String type = "Credential";
    private String description;
    private List<Object> annotations;
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public Credential withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Object> annotations() {
        return this.annotations;
    }

    public Credential withAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public Credential withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeUntyped(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Credential fromJson(JsonReader jsonReader) throws IOException {
        return (Credential)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Credential credential;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ServicePrincipal".equals(discriminatorValue)) {
                    credential = ServicePrincipalCredential.fromJson(readerToUse.reset());
                    return credential;
                }
                if ("ManagedIdentity".equals(discriminatorValue)) {
                    credential = ManagedIdentityCredential.fromJson(readerToUse.reset());
                    return credential;
                }
                credential = Credential.fromJsonKnownDiscriminator(readerToUse.reset());
                return credential;
            }
        });
    }

    static Credential fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (Credential)jsonReader.readObject(reader -> {
            Credential deserializedCredential = new Credential();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCredential.type = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCredential.description = reader.getString();
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations;
                    deserializedCredential.annotations = annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCredential.additionalProperties = additionalProperties;
            return deserializedCredential;
        });
    }
}

