/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BigDataPoolReferenceType;
import java.io.IOException;

public final class BigDataPoolParametrizationReference
implements JsonSerializable<BigDataPoolParametrizationReference> {
    private BigDataPoolReferenceType type;
    private Object referenceName;
    private static final ClientLogger LOGGER = new ClientLogger(BigDataPoolParametrizationReference.class);

    public BigDataPoolReferenceType type() {
        return this.type;
    }

    public BigDataPoolParametrizationReference withType(BigDataPoolReferenceType type) {
        this.type = type;
        return this;
    }

    public Object referenceName() {
        return this.referenceName;
    }

    public BigDataPoolParametrizationReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model BigDataPoolParametrizationReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model BigDataPoolParametrizationReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeUntypedField("referenceName", this.referenceName);
        return jsonWriter.writeEndObject();
    }

    public static BigDataPoolParametrizationReference fromJson(JsonReader jsonReader) throws IOException {
        return (BigDataPoolParametrizationReference)jsonReader.readObject(reader -> {
            BigDataPoolParametrizationReference deserializedBigDataPoolParametrizationReference = new BigDataPoolParametrizationReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedBigDataPoolParametrizationReference.type = BigDataPoolReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedBigDataPoolParametrizationReference.referenceName = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBigDataPoolParametrizationReference;
        });
    }
}

