/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureFileStorageLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureFileStorageLinkedService
extends LinkedService {
    private String type = "AzureFileStorage";
    private AzureFileStorageLinkedServiceTypeProperties innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureFileStorageLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureFileStorageLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureFileStorageLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureFileStorageLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object host() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().host();
    }

    public AzureFileStorageLinkedService withHost(Object host) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHost(host);
        return this;
    }

    public Object userId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().userId();
    }

    public AzureFileStorageLinkedService withUserId(Object userId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUserId(userId);
        return this;
    }

    public SecretBase password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public AzureFileStorageLinkedService withPassword(SecretBase password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public AzureFileStorageLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public AzureKeyVaultSecretReference accountKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().accountKey();
    }

    public AzureFileStorageLinkedService withAccountKey(AzureKeyVaultSecretReference accountKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAccountKey(accountKey);
        return this;
    }

    public Object sasUri() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sasUri();
    }

    public AzureFileStorageLinkedService withSasUri(Object sasUri) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSasUri(sasUri);
        return this;
    }

    public AzureKeyVaultSecretReference sasToken() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sasToken();
    }

    public AzureFileStorageLinkedService withSasToken(AzureKeyVaultSecretReference sasToken) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSasToken(sasToken);
        return this;
    }

    public Object fileShare() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().fileShare();
    }

    public AzureFileStorageLinkedService withFileShare(Object fileShare) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFileShare(fileShare);
        return this;
    }

    public Object snapshot() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().snapshot();
    }

    public AzureFileStorageLinkedService withSnapshot(Object snapshot) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withSnapshot(snapshot);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureFileStorageLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public Object serviceEndpoint() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().serviceEndpoint();
    }

    public AzureFileStorageLinkedService withServiceEndpoint(Object serviceEndpoint) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServiceEndpoint(serviceEndpoint);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureFileStorageLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureFileStorageLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureFileStorageLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileStorageLinkedService)jsonReader.readObject(reader -> {
            AzureFileStorageLinkedService deserializedAzureFileStorageLinkedService = new AzureFileStorageLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureFileStorageLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureFileStorageLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.innerTypeProperties = AzureFileStorageLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureFileStorageLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureFileStorageLinkedService;
        });
    }
}

