/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDataExplorerSource
extends CopySource {
    private String type = "AzureDataExplorerSource";
    private Object query;
    private Object noTruncation;
    private Object queryTimeout;
    private Object additionalColumns;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDataExplorerSource.class);

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public AzureDataExplorerSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object noTruncation() {
        return this.noTruncation;
    }

    public AzureDataExplorerSource withNoTruncation(Object noTruncation) {
        this.noTruncation = noTruncation;
        return this;
    }

    public Object queryTimeout() {
        return this.queryTimeout;
    }

    public AzureDataExplorerSource withQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public AzureDataExplorerSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public AzureDataExplorerSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public AzureDataExplorerSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public AzureDataExplorerSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureDataExplorerSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.query() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property query in model AzureDataExplorerSource"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("query", this.query);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("noTruncation", this.noTruncation);
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDataExplorerSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataExplorerSource)jsonReader.readObject(reader -> {
            AzureDataExplorerSource deserializedAzureDataExplorerSource = new AzureDataExplorerSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.query = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.type = reader.getString();
                    continue;
                }
                if ("noTruncation".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.noTruncation = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedAzureDataExplorerSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDataExplorerSource.withAdditionalProperties(additionalProperties);
            return deserializedAzureDataExplorerSource;
        });
    }
}

