/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureBlobStorageLocation
extends DatasetLocation {
    private String type = "AzureBlobStorageLocation";
    private Object container;

    @Override
    public String type() {
        return this.type;
    }

    public Object container() {
        return this.container;
    }

    public AzureBlobStorageLocation withContainer(Object container) {
        this.container = container;
        return this;
    }

    @Override
    public AzureBlobStorageLocation withFolderPath(Object folderPath) {
        super.withFolderPath(folderPath);
        return this;
    }

    @Override
    public AzureBlobStorageLocation withFileName(Object fileName) {
        super.withFileName(fileName);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("folderPath", this.folderPath());
        jsonWriter.writeUntypedField("fileName", this.fileName());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("container", this.container);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageLocation fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageLocation)jsonReader.readObject(reader -> {
            AzureBlobStorageLocation deserializedAzureBlobStorageLocation = new AzureBlobStorageLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAzureBlobStorageLocation.withFolderPath(reader.readUntyped());
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAzureBlobStorageLocation.withFileName(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureBlobStorageLocation.type = reader.getString();
                    continue;
                }
                if ("container".equals(fieldName)) {
                    deserializedAzureBlobStorageLocation.container = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureBlobStorageLocation.withAdditionalProperties(additionalProperties);
            return deserializedAzureBlobStorageLocation;
        });
    }
}

