/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AmazonS3DatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AmazonS3Dataset
extends Dataset {
    private String type = "AmazonS3Object";
    private AmazonS3DatasetTypeProperties innerTypeProperties = new AmazonS3DatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AmazonS3Dataset.class);

    @Override
    public String type() {
        return this.type;
    }

    AmazonS3DatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AmazonS3Dataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AmazonS3Dataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public AmazonS3Dataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public AmazonS3Dataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public AmazonS3Dataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AmazonS3Dataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public AmazonS3Dataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object bucketName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().bucketName();
    }

    public AmazonS3Dataset withBucketName(Object bucketName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withBucketName(bucketName);
        return this;
    }

    public Object key() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().key();
    }

    public AmazonS3Dataset withKey(Object key) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withKey(key);
        return this;
    }

    public Object prefix() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().prefix();
    }

    public AmazonS3Dataset withPrefix(Object prefix) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withPrefix(prefix);
        return this;
    }

    public Object version() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().version();
    }

    public AmazonS3Dataset withVersion(Object version) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withVersion(version);
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeStart();
    }

    public AmazonS3Dataset withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeStart(modifiedDatetimeStart);
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().modifiedDatetimeEnd();
    }

    public AmazonS3Dataset withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withModifiedDatetimeEnd(modifiedDatetimeEnd);
        return this;
    }

    public DatasetStorageFormat format() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().format();
    }

    public AmazonS3Dataset withFormat(DatasetStorageFormat format) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withFormat(format);
        return this;
    }

    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    public AmazonS3Dataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AmazonS3DatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AmazonS3Dataset"));
        }
        this.innerTypeProperties().validate();
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model AmazonS3Dataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AmazonS3Dataset fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonS3Dataset)jsonReader.readObject(reader -> {
            AmazonS3Dataset deserializedAmazonS3Dataset = new AmazonS3Dataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedAmazonS3Dataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAmazonS3Dataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedAmazonS3Dataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedAmazonS3Dataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAmazonS3Dataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAmazonS3Dataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedAmazonS3Dataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAmazonS3Dataset.innerTypeProperties = AmazonS3DatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmazonS3Dataset.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAmazonS3Dataset.withAdditionalProperties(additionalProperties);
            return deserializedAmazonS3Dataset;
        });
    }
}

