/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.CreateRunResponse;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PipelineFolder;
import com.azure.resourcemanager.datafactory.models.PipelinePolicy;
import com.azure.resourcemanager.datafactory.models.PipelineResource;
import com.azure.resourcemanager.datafactory.models.VariableSpecification;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class PipelineResourceImpl
implements PipelineResource,
PipelineResource.Definition,
PipelineResource.Update {
    private PipelineResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String pipelineName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public Map<String, Object> additionalProperties() {
        Map<String, Object> inner = this.innerModel().additionalProperties();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public List<Activity> activities() {
        List<Activity> inner = this.innerModel().activities();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, ParameterSpecification> parameters() {
        Map<String, ParameterSpecification> inner = this.innerModel().parameters();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, VariableSpecification> variables() {
        Map<String, VariableSpecification> inner = this.innerModel().variables();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public Integer concurrency() {
        return this.innerModel().concurrency();
    }

    @Override
    public List<Object> annotations() {
        List<Object> inner = this.innerModel().annotations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> runDimensions() {
        Map<String, Object> inner = this.innerModel().runDimensions();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public PipelineFolder folder() {
        return this.innerModel().folder();
    }

    @Override
    public PipelinePolicy policy() {
        return this.innerModel().policy();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PipelineResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public PipelineResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public PipelineResource create() {
        this.innerObject = (PipelineResourceInner)((Object)this.serviceManager.serviceClient().getPipelines().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public PipelineResource create(Context context) {
        this.innerObject = (PipelineResourceInner)((Object)this.serviceManager.serviceClient().getPipelines().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    PipelineResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new PipelineResourceInner();
        this.serviceManager = serviceManager;
        this.pipelineName = name;
        this.createIfMatch = null;
    }

    @Override
    public PipelineResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public PipelineResource apply() {
        this.innerObject = (PipelineResourceInner)((Object)this.serviceManager.serviceClient().getPipelines().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public PipelineResource apply(Context context) {
        this.innerObject = (PipelineResourceInner)((Object)this.serviceManager.serviceClient().getPipelines().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    PipelineResourceImpl(PipelineResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.pipelineName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "pipelines");
    }

    @Override
    public PipelineResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (PipelineResourceInner)((Object)this.serviceManager.serviceClient().getPipelines().getWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public PipelineResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (PipelineResourceInner)((Object)this.serviceManager.serviceClient().getPipelines().getWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public Response<CreateRunResponse> createRunWithResponse(String referencePipelineRunId, Boolean isRecovery, String startActivityName, Boolean startFromFailure, Map<String, Object> parameters, Context context) {
        return this.serviceManager.pipelines().createRunWithResponse(this.resourceGroupName, this.factoryName, this.pipelineName, referencePipelineRunId, isRecovery, startActivityName, startFromFailure, parameters, context);
    }

    @Override
    public CreateRunResponse createRun() {
        return this.serviceManager.pipelines().createRun(this.resourceGroupName, this.factoryName, this.pipelineName);
    }

    @Override
    public PipelineResourceImpl withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.innerModel().withAdditionalProperties(additionalProperties);
        return this;
    }

    @Override
    public PipelineResourceImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public PipelineResourceImpl withActivities(List<Activity> activities) {
        this.innerModel().withActivities(activities);
        return this;
    }

    @Override
    public PipelineResourceImpl withParameters(Map<String, ParameterSpecification> parameters) {
        this.innerModel().withParameters(parameters);
        return this;
    }

    @Override
    public PipelineResourceImpl withVariables(Map<String, VariableSpecification> variables) {
        this.innerModel().withVariables(variables);
        return this;
    }

    @Override
    public PipelineResourceImpl withConcurrency(Integer concurrency) {
        this.innerModel().withConcurrency(concurrency);
        return this;
    }

    @Override
    public PipelineResourceImpl withAnnotations(List<Object> annotations) {
        this.innerModel().withAnnotations(annotations);
        return this;
    }

    @Override
    public PipelineResourceImpl withRunDimensions(Map<String, Object> runDimensions) {
        this.innerModel().withRunDimensions(runDimensions);
        return this;
    }

    @Override
    public PipelineResourceImpl withFolder(PipelineFolder folder) {
        this.innerModel().withFolder(folder);
        return this;
    }

    @Override
    public PipelineResourceImpl withPolicy(PipelinePolicy policy) {
        this.innerModel().withPolicy(policy);
        return this;
    }

    @Override
    public PipelineResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

