/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.LinkedServiceResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.LinkedServiceResource;

public final class LinkedServiceResourceImpl
implements LinkedServiceResource,
LinkedServiceResource.Definition,
LinkedServiceResource.Update {
    private LinkedServiceResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String linkedServiceName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public LinkedService properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public LinkedServiceResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public LinkedServiceResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public LinkedServiceResource create() {
        this.innerObject = (LinkedServiceResourceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.linkedServiceName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedServiceResource create(Context context) {
        this.innerObject = (LinkedServiceResourceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.linkedServiceName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    LinkedServiceResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new LinkedServiceResourceInner();
        this.serviceManager = serviceManager;
        this.linkedServiceName = name;
        this.createIfMatch = null;
    }

    @Override
    public LinkedServiceResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public LinkedServiceResource apply() {
        this.innerObject = (LinkedServiceResourceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.linkedServiceName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedServiceResource apply(Context context) {
        this.innerObject = (LinkedServiceResourceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.linkedServiceName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    LinkedServiceResourceImpl(LinkedServiceResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.linkedServiceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "linkedservices");
    }

    @Override
    public LinkedServiceResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (LinkedServiceResourceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().getWithResponse(this.resourceGroupName, this.factoryName, this.linkedServiceName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkedServiceResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (LinkedServiceResourceInner)((Object)this.serviceManager.serviceClient().getLinkedServices().getWithResponse(this.resourceGroupName, this.factoryName, this.linkedServiceName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public LinkedServiceResourceImpl withProperties(LinkedService properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public LinkedServiceResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

