/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.CredentialResourceInner;
import com.azure.resourcemanager.datafactory.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datafactory.models.Credential;
import com.azure.resourcemanager.datafactory.models.CredentialResource;

public final class CredentialResourceImpl
implements CredentialResource,
CredentialResource.Definition,
CredentialResource.Update {
    private CredentialResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String credentialName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public Credential properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CredentialResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public CredentialResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public CredentialResource create() {
        this.innerObject = (CredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public CredentialResource create(Context context) {
        this.innerObject = (CredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    CredentialResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new CredentialResourceInner();
        this.serviceManager = serviceManager;
        this.credentialName = name;
        this.createIfMatch = null;
    }

    @Override
    public CredentialResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public CredentialResource apply() {
        this.innerObject = (CredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public CredentialResource apply(Context context) {
        this.innerObject = (CredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    CredentialResourceImpl(CredentialResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "factories");
        this.credentialName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "credentials");
    }

    @Override
    public CredentialResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (CredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().getWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public CredentialResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (CredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().getWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public CredentialResourceImpl withProperties(Credential properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public CredentialResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

