/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.WebActivityAuthentication;
import com.azure.resourcemanager.datafactory.models.WebhookActivityMethod;
import java.io.IOException;
import java.util.Map;

public final class WebhookActivityTypeProperties
implements JsonSerializable<WebhookActivityTypeProperties> {
    private WebhookActivityMethod method;
    private Object url;
    private String timeout;
    private Map<String, Object> headers;
    private Object body;
    private WebActivityAuthentication authentication;
    private Object reportStatusOnCallBack;
    private static final ClientLogger LOGGER = new ClientLogger(WebhookActivityTypeProperties.class);

    public WebhookActivityMethod method() {
        return this.method;
    }

    public WebhookActivityTypeProperties withMethod(WebhookActivityMethod method) {
        this.method = method;
        return this;
    }

    public Object url() {
        return this.url;
    }

    public WebhookActivityTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public String timeout() {
        return this.timeout;
    }

    public WebhookActivityTypeProperties withTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public Map<String, Object> headers() {
        return this.headers;
    }

    public WebhookActivityTypeProperties withHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public Object body() {
        return this.body;
    }

    public WebhookActivityTypeProperties withBody(Object body) {
        this.body = body;
        return this;
    }

    public WebActivityAuthentication authentication() {
        return this.authentication;
    }

    public WebhookActivityTypeProperties withAuthentication(WebActivityAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public Object reportStatusOnCallBack() {
        return this.reportStatusOnCallBack;
    }

    public WebhookActivityTypeProperties withReportStatusOnCallBack(Object reportStatusOnCallBack) {
        this.reportStatusOnCallBack = reportStatusOnCallBack;
        return this;
    }

    public void validate() {
        if (this.method() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property method in model WebhookActivityTypeProperties"));
        }
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model WebhookActivityTypeProperties"));
        }
        if (this.authentication() != null) {
            this.authentication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("method", this.method == null ? null : this.method.toString());
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeStringField("timeout", this.timeout);
        jsonWriter.writeMapField("headers", this.headers, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeUntypedField("body", this.body);
        jsonWriter.writeJsonField("authentication", (JsonSerializable)this.authentication);
        jsonWriter.writeUntypedField("reportStatusOnCallBack", this.reportStatusOnCallBack);
        return jsonWriter.writeEndObject();
    }

    public static WebhookActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WebhookActivityTypeProperties)jsonReader.readObject(reader -> {
            WebhookActivityTypeProperties deserializedWebhookActivityTypeProperties = new WebhookActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("method".equals(fieldName)) {
                    deserializedWebhookActivityTypeProperties.method = WebhookActivityMethod.fromString(reader.getString());
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedWebhookActivityTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedWebhookActivityTypeProperties.timeout = reader.getString();
                    continue;
                }
                if ("headers".equals(fieldName)) {
                    Map headers;
                    deserializedWebhookActivityTypeProperties.headers = headers = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedWebhookActivityTypeProperties.body = reader.readUntyped();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedWebhookActivityTypeProperties.authentication = WebActivityAuthentication.fromJson(reader);
                    continue;
                }
                if ("reportStatusOnCallBack".equals(fieldName)) {
                    deserializedWebhookActivityTypeProperties.reportStatusOnCallBack = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebhookActivityTypeProperties;
        });
    }
}

