/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import java.io.IOException;

public final class ValidationActivityTypeProperties
implements JsonSerializable<ValidationActivityTypeProperties> {
    private Object timeout;
    private Object sleep;
    private Object minimumSize;
    private Object childItems;
    private DatasetReference dataset;
    private static final ClientLogger LOGGER = new ClientLogger(ValidationActivityTypeProperties.class);

    public Object timeout() {
        return this.timeout;
    }

    public ValidationActivityTypeProperties withTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    public Object sleep() {
        return this.sleep;
    }

    public ValidationActivityTypeProperties withSleep(Object sleep) {
        this.sleep = sleep;
        return this;
    }

    public Object minimumSize() {
        return this.minimumSize;
    }

    public ValidationActivityTypeProperties withMinimumSize(Object minimumSize) {
        this.minimumSize = minimumSize;
        return this;
    }

    public Object childItems() {
        return this.childItems;
    }

    public ValidationActivityTypeProperties withChildItems(Object childItems) {
        this.childItems = childItems;
        return this;
    }

    public DatasetReference dataset() {
        return this.dataset;
    }

    public ValidationActivityTypeProperties withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public void validate() {
        if (this.dataset() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataset in model ValidationActivityTypeProperties"));
        }
        this.dataset().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        jsonWriter.writeUntypedField("timeout", this.timeout);
        jsonWriter.writeUntypedField("sleep", this.sleep);
        jsonWriter.writeUntypedField("minimumSize", this.minimumSize);
        jsonWriter.writeUntypedField("childItems", this.childItems);
        return jsonWriter.writeEndObject();
    }

    public static ValidationActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationActivityTypeProperties)jsonReader.readObject(reader -> {
            ValidationActivityTypeProperties deserializedValidationActivityTypeProperties = new ValidationActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataset".equals(fieldName)) {
                    deserializedValidationActivityTypeProperties.dataset = DatasetReference.fromJson(reader);
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedValidationActivityTypeProperties.timeout = reader.readUntyped();
                    continue;
                }
                if ("sleep".equals(fieldName)) {
                    deserializedValidationActivityTypeProperties.sleep = reader.readUntyped();
                    continue;
                }
                if ("minimumSize".equals(fieldName)) {
                    deserializedValidationActivityTypeProperties.minimumSize = reader.readUntyped();
                    continue;
                }
                if ("childItems".equals(fieldName)) {
                    deserializedValidationActivityTypeProperties.childItems = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationActivityTypeProperties;
        });
    }
}

