/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.SnowflakeAuthenticationType;
import java.io.IOException;

public final class SnowflakeLinkedV2ServiceTypeProperties
implements JsonSerializable<SnowflakeLinkedV2ServiceTypeProperties> {
    private Object accountIdentifier;
    private Object user;
    private SecretBase password;
    private Object database;
    private Object warehouse;
    private SnowflakeAuthenticationType authenticationType;
    private Object clientId;
    private SecretBase clientSecret;
    private Object tenantId;
    private Object scope;
    private SecretBase privateKey;
    private SecretBase privateKeyPassphrase;
    private Object role;
    private Object host;
    private Object schema;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeLinkedV2ServiceTypeProperties.class);

    public Object accountIdentifier() {
        return this.accountIdentifier;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withAccountIdentifier(Object accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    public Object user() {
        return this.user;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withUser(Object user) {
        this.user = user;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object warehouse() {
        return this.warehouse;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withWarehouse(Object warehouse) {
        this.warehouse = warehouse;
        return this;
    }

    public SnowflakeAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withAuthenticationType(SnowflakeAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object clientId() {
        return this.clientId;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase clientSecret() {
        return this.clientSecret;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object tenantId() {
        return this.tenantId;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withTenantId(Object tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Object scope() {
        return this.scope;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withScope(Object scope) {
        this.scope = scope;
        return this;
    }

    public SecretBase privateKey() {
        return this.privateKey;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SecretBase privateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withPrivateKeyPassphrase(SecretBase privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
        return this;
    }

    public Object role() {
        return this.role;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withRole(Object role) {
        this.role = role;
        return this;
    }

    public Object host() {
        return this.host;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object schema() {
        return this.schema;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public SnowflakeLinkedV2ServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.accountIdentifier() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountIdentifier in model SnowflakeLinkedV2ServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.database() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property database in model SnowflakeLinkedV2ServiceTypeProperties"));
        }
        if (this.warehouse() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property warehouse in model SnowflakeLinkedV2ServiceTypeProperties"));
        }
        if (this.clientSecret() != null) {
            this.clientSecret().validate();
        }
        if (this.privateKey() != null) {
            this.privateKey().validate();
        }
        if (this.privateKeyPassphrase() != null) {
            this.privateKeyPassphrase().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("accountIdentifier", this.accountIdentifier);
        jsonWriter.writeUntypedField("database", this.database);
        jsonWriter.writeUntypedField("warehouse", this.warehouse);
        jsonWriter.writeUntypedField("user", this.user);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        jsonWriter.writeUntypedField("tenantId", this.tenantId);
        jsonWriter.writeUntypedField("scope", this.scope);
        jsonWriter.writeJsonField("privateKey", (JsonSerializable)this.privateKey);
        jsonWriter.writeJsonField("privateKeyPassphrase", (JsonSerializable)this.privateKeyPassphrase);
        jsonWriter.writeUntypedField("role", this.role);
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("schema", this.schema);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeLinkedV2ServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeLinkedV2ServiceTypeProperties)jsonReader.readObject(reader -> {
            SnowflakeLinkedV2ServiceTypeProperties deserializedSnowflakeLinkedV2ServiceTypeProperties = new SnowflakeLinkedV2ServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountIdentifier".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.accountIdentifier = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("warehouse".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.warehouse = reader.readUntyped();
                    continue;
                }
                if ("user".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.user = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.authenticationType = SnowflakeAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.clientId = reader.readUntyped();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.clientSecret = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.tenantId = reader.readUntyped();
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.scope = reader.readUntyped();
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.privateKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("privateKeyPassphrase".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.privateKeyPassphrase = SecretBase.fromJson(reader);
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.role = reader.readUntyped();
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.schema = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedSnowflakeLinkedV2ServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnowflakeLinkedV2ServiceTypeProperties;
        });
    }
}

