/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.OracleAuthenticationType;
import java.io.IOException;

public final class OracleLinkedServiceTypeProperties
implements JsonSerializable<OracleLinkedServiceTypeProperties> {
    private Object connectionString;
    private Object server;
    private OracleAuthenticationType authenticationType;
    private Object username;
    private AzureKeyVaultSecretReference password;
    private Object encryptionClient;
    private Object encryptionTypesClient;
    private Object cryptoChecksumClient;
    private Object cryptoChecksumTypesClient;
    private Object initialLobFetchSize;
    private Object fetchSize;
    private Object statementCacheSize;
    private Object initializationString;
    private Object enableBulkLoad;
    private Object supportV1DataTypes;
    private Object fetchTswtzAsTimestamp;
    private String encryptedCredential;

    public Object connectionString() {
        return this.connectionString;
    }

    public OracleLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object server() {
        return this.server;
    }

    public OracleLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public OracleAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public OracleLinkedServiceTypeProperties withAuthenticationType(OracleAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public OracleLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.password;
    }

    public OracleLinkedServiceTypeProperties withPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object encryptionClient() {
        return this.encryptionClient;
    }

    public OracleLinkedServiceTypeProperties withEncryptionClient(Object encryptionClient) {
        this.encryptionClient = encryptionClient;
        return this;
    }

    public Object encryptionTypesClient() {
        return this.encryptionTypesClient;
    }

    public OracleLinkedServiceTypeProperties withEncryptionTypesClient(Object encryptionTypesClient) {
        this.encryptionTypesClient = encryptionTypesClient;
        return this;
    }

    public Object cryptoChecksumClient() {
        return this.cryptoChecksumClient;
    }

    public OracleLinkedServiceTypeProperties withCryptoChecksumClient(Object cryptoChecksumClient) {
        this.cryptoChecksumClient = cryptoChecksumClient;
        return this;
    }

    public Object cryptoChecksumTypesClient() {
        return this.cryptoChecksumTypesClient;
    }

    public OracleLinkedServiceTypeProperties withCryptoChecksumTypesClient(Object cryptoChecksumTypesClient) {
        this.cryptoChecksumTypesClient = cryptoChecksumTypesClient;
        return this;
    }

    public Object initialLobFetchSize() {
        return this.initialLobFetchSize;
    }

    public OracleLinkedServiceTypeProperties withInitialLobFetchSize(Object initialLobFetchSize) {
        this.initialLobFetchSize = initialLobFetchSize;
        return this;
    }

    public Object fetchSize() {
        return this.fetchSize;
    }

    public OracleLinkedServiceTypeProperties withFetchSize(Object fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public Object statementCacheSize() {
        return this.statementCacheSize;
    }

    public OracleLinkedServiceTypeProperties withStatementCacheSize(Object statementCacheSize) {
        this.statementCacheSize = statementCacheSize;
        return this;
    }

    public Object initializationString() {
        return this.initializationString;
    }

    public OracleLinkedServiceTypeProperties withInitializationString(Object initializationString) {
        this.initializationString = initializationString;
        return this;
    }

    public Object enableBulkLoad() {
        return this.enableBulkLoad;
    }

    public OracleLinkedServiceTypeProperties withEnableBulkLoad(Object enableBulkLoad) {
        this.enableBulkLoad = enableBulkLoad;
        return this;
    }

    public Object supportV1DataTypes() {
        return this.supportV1DataTypes;
    }

    public OracleLinkedServiceTypeProperties withSupportV1DataTypes(Object supportV1DataTypes) {
        this.supportV1DataTypes = supportV1DataTypes;
        return this;
    }

    public Object fetchTswtzAsTimestamp() {
        return this.fetchTswtzAsTimestamp;
    }

    public OracleLinkedServiceTypeProperties withFetchTswtzAsTimestamp(Object fetchTswtzAsTimestamp) {
        this.fetchTswtzAsTimestamp = fetchTswtzAsTimestamp;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public OracleLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("encryptionClient", this.encryptionClient);
        jsonWriter.writeUntypedField("encryptionTypesClient", this.encryptionTypesClient);
        jsonWriter.writeUntypedField("cryptoChecksumClient", this.cryptoChecksumClient);
        jsonWriter.writeUntypedField("cryptoChecksumTypesClient", this.cryptoChecksumTypesClient);
        jsonWriter.writeUntypedField("initialLobFetchSize", this.initialLobFetchSize);
        jsonWriter.writeUntypedField("fetchSize", this.fetchSize);
        jsonWriter.writeUntypedField("statementCacheSize", this.statementCacheSize);
        jsonWriter.writeUntypedField("initializationString", this.initializationString);
        jsonWriter.writeUntypedField("enableBulkLoad", this.enableBulkLoad);
        jsonWriter.writeUntypedField("supportV1DataTypes", this.supportV1DataTypes);
        jsonWriter.writeUntypedField("fetchTswtzAsTimestamp", this.fetchTswtzAsTimestamp);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static OracleLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OracleLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            OracleLinkedServiceTypeProperties deserializedOracleLinkedServiceTypeProperties = new OracleLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("server".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.authenticationType = OracleAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.password = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("encryptionClient".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.encryptionClient = reader.readUntyped();
                    continue;
                }
                if ("encryptionTypesClient".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.encryptionTypesClient = reader.readUntyped();
                    continue;
                }
                if ("cryptoChecksumClient".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.cryptoChecksumClient = reader.readUntyped();
                    continue;
                }
                if ("cryptoChecksumTypesClient".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.cryptoChecksumTypesClient = reader.readUntyped();
                    continue;
                }
                if ("initialLobFetchSize".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.initialLobFetchSize = reader.readUntyped();
                    continue;
                }
                if ("fetchSize".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.fetchSize = reader.readUntyped();
                    continue;
                }
                if ("statementCacheSize".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.statementCacheSize = reader.readUntyped();
                    continue;
                }
                if ("initializationString".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.initializationString = reader.readUntyped();
                    continue;
                }
                if ("enableBulkLoad".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.enableBulkLoad = reader.readUntyped();
                    continue;
                }
                if ("supportV1DataTypes".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.supportV1DataTypes = reader.readUntyped();
                    continue;
                }
                if ("fetchTswtzAsTimestamp".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.fetchTswtzAsTimestamp = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedOracleLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOracleLinkedServiceTypeProperties;
        });
    }
}

