/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class LicensedComponentSetupTypeProperties
implements JsonSerializable<LicensedComponentSetupTypeProperties> {
    private String componentName;
    private SecretBase licenseKey;
    private static final ClientLogger LOGGER = new ClientLogger(LicensedComponentSetupTypeProperties.class);

    public String componentName() {
        return this.componentName;
    }

    public LicensedComponentSetupTypeProperties withComponentName(String componentName) {
        this.componentName = componentName;
        return this;
    }

    public SecretBase licenseKey() {
        return this.licenseKey;
    }

    public LicensedComponentSetupTypeProperties withLicenseKey(SecretBase licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    public void validate() {
        if (this.componentName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property componentName in model LicensedComponentSetupTypeProperties"));
        }
        if (this.licenseKey() != null) {
            this.licenseKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentName", this.componentName);
        jsonWriter.writeJsonField("licenseKey", (JsonSerializable)this.licenseKey);
        return jsonWriter.writeEndObject();
    }

    public static LicensedComponentSetupTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LicensedComponentSetupTypeProperties)jsonReader.readObject(reader -> {
            LicensedComponentSetupTypeProperties deserializedLicensedComponentSetupTypeProperties = new LicensedComponentSetupTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("componentName".equals(fieldName)) {
                    deserializedLicensedComponentSetupTypeProperties.componentName = reader.getString();
                    continue;
                }
                if ("licenseKey".equals(fieldName)) {
                    deserializedLicensedComponentSetupTypeProperties.licenseKey = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLicensedComponentSetupTypeProperties;
        });
    }
}

