/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class IcebergDatasetTypeProperties
implements JsonSerializable<IcebergDatasetTypeProperties> {
    private DatasetLocation location;
    private static final ClientLogger LOGGER = new ClientLogger(IcebergDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public IcebergDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model IcebergDatasetTypeProperties"));
        }
        this.location().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        return jsonWriter.writeEndObject();
    }

    public static IcebergDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IcebergDatasetTypeProperties)jsonReader.readObject(reader -> {
            IcebergDatasetTypeProperties deserializedIcebergDatasetTypeProperties = new IcebergDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedIcebergDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIcebergDatasetTypeProperties;
        });
    }
}

