/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class HDInsightLinkedServiceTypeProperties
implements JsonSerializable<HDInsightLinkedServiceTypeProperties> {
    private Object clusterUri;
    private Object username;
    private SecretBase password;
    private LinkedServiceReference linkedServiceName;
    private LinkedServiceReference hcatalogLinkedServiceName;
    private String encryptedCredential;
    private Object isEspEnabled;
    private Object fileSystem;
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightLinkedServiceTypeProperties.class);

    public Object clusterUri() {
        return this.clusterUri;
    }

    public HDInsightLinkedServiceTypeProperties withClusterUri(Object clusterUri) {
        this.clusterUri = clusterUri;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public HDInsightLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public HDInsightLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public LinkedServiceReference linkedServiceName() {
        return this.linkedServiceName;
    }

    public HDInsightLinkedServiceTypeProperties withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        this.linkedServiceName = linkedServiceName;
        return this;
    }

    public LinkedServiceReference hcatalogLinkedServiceName() {
        return this.hcatalogLinkedServiceName;
    }

    public HDInsightLinkedServiceTypeProperties withHcatalogLinkedServiceName(LinkedServiceReference hcatalogLinkedServiceName) {
        this.hcatalogLinkedServiceName = hcatalogLinkedServiceName;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HDInsightLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object isEspEnabled() {
        return this.isEspEnabled;
    }

    public HDInsightLinkedServiceTypeProperties withIsEspEnabled(Object isEspEnabled) {
        this.isEspEnabled = isEspEnabled;
        return this;
    }

    public Object fileSystem() {
        return this.fileSystem;
    }

    public HDInsightLinkedServiceTypeProperties withFileSystem(Object fileSystem) {
        this.fileSystem = fileSystem;
        return this;
    }

    public void validate() {
        if (this.clusterUri() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterUri in model HDInsightLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.hcatalogLinkedServiceName() != null) {
            this.hcatalogLinkedServiceName().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("clusterUri", this.clusterUri);
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName);
        jsonWriter.writeJsonField("hcatalogLinkedServiceName", (JsonSerializable)this.hcatalogLinkedServiceName);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeUntypedField("isEspEnabled", this.isEspEnabled);
        jsonWriter.writeUntypedField("fileSystem", this.fileSystem);
        return jsonWriter.writeEndObject();
    }

    public static HDInsightLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HDInsightLinkedServiceTypeProperties deserializedHDInsightLinkedServiceTypeProperties = new HDInsightLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clusterUri".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.clusterUri = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.linkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("hcatalogLinkedServiceName".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.hcatalogLinkedServiceName = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("isEspEnabled".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.isEspEnabled = reader.readUntyped();
                    continue;
                }
                if ("fileSystem".equals(fieldName)) {
                    deserializedHDInsightLinkedServiceTypeProperties.fileSystem = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHDInsightLinkedServiceTypeProperties;
        });
    }
}

