/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.Expression;
import java.io.IOException;
import java.util.List;

public final class ForEachActivityTypeProperties
implements JsonSerializable<ForEachActivityTypeProperties> {
    private Boolean isSequential;
    private Integer batchCount;
    private Expression items;
    private List<Activity> activities;
    private static final ClientLogger LOGGER = new ClientLogger(ForEachActivityTypeProperties.class);

    public Boolean isSequential() {
        return this.isSequential;
    }

    public ForEachActivityTypeProperties withIsSequential(Boolean isSequential) {
        this.isSequential = isSequential;
        return this;
    }

    public Integer batchCount() {
        return this.batchCount;
    }

    public ForEachActivityTypeProperties withBatchCount(Integer batchCount) {
        this.batchCount = batchCount;
        return this;
    }

    public Expression items() {
        return this.items;
    }

    public ForEachActivityTypeProperties withItems(Expression items) {
        this.items = items;
        return this;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public ForEachActivityTypeProperties withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public void validate() {
        if (this.items() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property items in model ForEachActivityTypeProperties"));
        }
        this.items().validate();
        if (this.activities() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property activities in model ForEachActivityTypeProperties"));
        }
        this.activities().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("items", (JsonSerializable)this.items);
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isSequential", this.isSequential);
        jsonWriter.writeNumberField("batchCount", (Number)this.batchCount);
        return jsonWriter.writeEndObject();
    }

    public static ForEachActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ForEachActivityTypeProperties)jsonReader.readObject(reader -> {
            ForEachActivityTypeProperties deserializedForEachActivityTypeProperties = new ForEachActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("items".equals(fieldName)) {
                    deserializedForEachActivityTypeProperties.items = Expression.fromJson(reader);
                    continue;
                }
                if ("activities".equals(fieldName)) {
                    List activities;
                    deserializedForEachActivityTypeProperties.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                if ("isSequential".equals(fieldName)) {
                    deserializedForEachActivityTypeProperties.isSequential = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("batchCount".equals(fieldName)) {
                    deserializedForEachActivityTypeProperties.batchCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForEachActivityTypeProperties;
        });
    }
}

