/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.PipelineReference;
import java.io.IOException;
import java.util.Map;

public final class ExecutePipelineActivityTypeProperties
implements JsonSerializable<ExecutePipelineActivityTypeProperties> {
    private PipelineReference pipeline;
    private Map<String, Object> parameters;
    private Boolean waitOnCompletion;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutePipelineActivityTypeProperties.class);

    public PipelineReference pipeline() {
        return this.pipeline;
    }

    public ExecutePipelineActivityTypeProperties withPipeline(PipelineReference pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public ExecutePipelineActivityTypeProperties withParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Boolean waitOnCompletion() {
        return this.waitOnCompletion;
    }

    public ExecutePipelineActivityTypeProperties withWaitOnCompletion(Boolean waitOnCompletion) {
        this.waitOnCompletion = waitOnCompletion;
        return this;
    }

    public void validate() {
        if (this.pipeline() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property pipeline in model ExecutePipelineActivityTypeProperties"));
        }
        this.pipeline().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("pipeline", (JsonSerializable)this.pipeline);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeBooleanField("waitOnCompletion", this.waitOnCompletion);
        return jsonWriter.writeEndObject();
    }

    public static ExecutePipelineActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutePipelineActivityTypeProperties)jsonReader.readObject(reader -> {
            ExecutePipelineActivityTypeProperties deserializedExecutePipelineActivityTypeProperties = new ExecutePipelineActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pipeline".equals(fieldName)) {
                    deserializedExecutePipelineActivityTypeProperties.pipeline = PipelineReference.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedExecutePipelineActivityTypeProperties.parameters = parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("waitOnCompletion".equals(fieldName)) {
                    deserializedExecutePipelineActivityTypeProperties.waitOnCompletion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutePipelineActivityTypeProperties;
        });
    }
}

