/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetLocation;
import java.io.IOException;

public final class DelimitedTextDatasetTypeProperties
implements JsonSerializable<DelimitedTextDatasetTypeProperties> {
    private DatasetLocation location;
    private Object columnDelimiter;
    private Object rowDelimiter;
    private Object encodingName;
    private Object compressionCodec;
    private Object compressionLevel;
    private Object quoteChar;
    private Object escapeChar;
    private Object firstRowAsHeader;
    private Object nullValue;
    private static final ClientLogger LOGGER = new ClientLogger(DelimitedTextDatasetTypeProperties.class);

    public DatasetLocation location() {
        return this.location;
    }

    public DelimitedTextDatasetTypeProperties withLocation(DatasetLocation location) {
        this.location = location;
        return this;
    }

    public Object columnDelimiter() {
        return this.columnDelimiter;
    }

    public DelimitedTextDatasetTypeProperties withColumnDelimiter(Object columnDelimiter) {
        this.columnDelimiter = columnDelimiter;
        return this;
    }

    public Object rowDelimiter() {
        return this.rowDelimiter;
    }

    public DelimitedTextDatasetTypeProperties withRowDelimiter(Object rowDelimiter) {
        this.rowDelimiter = rowDelimiter;
        return this;
    }

    public Object encodingName() {
        return this.encodingName;
    }

    public DelimitedTextDatasetTypeProperties withEncodingName(Object encodingName) {
        this.encodingName = encodingName;
        return this;
    }

    public Object compressionCodec() {
        return this.compressionCodec;
    }

    public DelimitedTextDatasetTypeProperties withCompressionCodec(Object compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public Object compressionLevel() {
        return this.compressionLevel;
    }

    public DelimitedTextDatasetTypeProperties withCompressionLevel(Object compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
    }

    public Object quoteChar() {
        return this.quoteChar;
    }

    public DelimitedTextDatasetTypeProperties withQuoteChar(Object quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public Object escapeChar() {
        return this.escapeChar;
    }

    public DelimitedTextDatasetTypeProperties withEscapeChar(Object escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    public Object firstRowAsHeader() {
        return this.firstRowAsHeader;
    }

    public DelimitedTextDatasetTypeProperties withFirstRowAsHeader(Object firstRowAsHeader) {
        this.firstRowAsHeader = firstRowAsHeader;
        return this;
    }

    public Object nullValue() {
        return this.nullValue;
    }

    public DelimitedTextDatasetTypeProperties withNullValue(Object nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model DelimitedTextDatasetTypeProperties"));
        }
        this.location().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        jsonWriter.writeUntypedField("columnDelimiter", this.columnDelimiter);
        jsonWriter.writeUntypedField("rowDelimiter", this.rowDelimiter);
        jsonWriter.writeUntypedField("encodingName", this.encodingName);
        jsonWriter.writeUntypedField("compressionCodec", this.compressionCodec);
        jsonWriter.writeUntypedField("compressionLevel", this.compressionLevel);
        jsonWriter.writeUntypedField("quoteChar", this.quoteChar);
        jsonWriter.writeUntypedField("escapeChar", this.escapeChar);
        jsonWriter.writeUntypedField("firstRowAsHeader", this.firstRowAsHeader);
        jsonWriter.writeUntypedField("nullValue", this.nullValue);
        return jsonWriter.writeEndObject();
    }

    public static DelimitedTextDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DelimitedTextDatasetTypeProperties)jsonReader.readObject(reader -> {
            DelimitedTextDatasetTypeProperties deserializedDelimitedTextDatasetTypeProperties = new DelimitedTextDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.location = DatasetLocation.fromJson(reader);
                    continue;
                }
                if ("columnDelimiter".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.columnDelimiter = reader.readUntyped();
                    continue;
                }
                if ("rowDelimiter".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.rowDelimiter = reader.readUntyped();
                    continue;
                }
                if ("encodingName".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.encodingName = reader.readUntyped();
                    continue;
                }
                if ("compressionCodec".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.compressionCodec = reader.readUntyped();
                    continue;
                }
                if ("compressionLevel".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.compressionLevel = reader.readUntyped();
                    continue;
                }
                if ("quoteChar".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.quoteChar = reader.readUntyped();
                    continue;
                }
                if ("escapeChar".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.escapeChar = reader.readUntyped();
                    continue;
                }
                if ("firstRowAsHeader".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.firstRowAsHeader = reader.readUntyped();
                    continue;
                }
                if ("nullValue".equals(fieldName)) {
                    deserializedDelimitedTextDatasetTypeProperties.nullValue = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDelimitedTextDatasetTypeProperties;
        });
    }
}

