/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DatabricksSparkPythonActivityTypeProperties
implements JsonSerializable<DatabricksSparkPythonActivityTypeProperties> {
    private Object pythonFile;
    private List<Object> parameters;
    private List<Map<String, Object>> libraries;
    private static final ClientLogger LOGGER = new ClientLogger(DatabricksSparkPythonActivityTypeProperties.class);

    public Object pythonFile() {
        return this.pythonFile;
    }

    public DatabricksSparkPythonActivityTypeProperties withPythonFile(Object pythonFile) {
        this.pythonFile = pythonFile;
        return this;
    }

    public List<Object> parameters() {
        return this.parameters;
    }

    public DatabricksSparkPythonActivityTypeProperties withParameters(List<Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<Map<String, Object>> libraries() {
        return this.libraries;
    }

    public DatabricksSparkPythonActivityTypeProperties withLibraries(List<Map<String, Object>> libraries) {
        this.libraries = libraries;
        return this;
    }

    public void validate() {
        if (this.pythonFile() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property pythonFile in model DatabricksSparkPythonActivityTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("pythonFile", this.pythonFile);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("libraries", this.libraries, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeUntyped(element1)));
        return jsonWriter.writeEndObject();
    }

    public static DatabricksSparkPythonActivityTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabricksSparkPythonActivityTypeProperties)jsonReader.readObject(reader -> {
            DatabricksSparkPythonActivityTypeProperties deserializedDatabricksSparkPythonActivityTypeProperties = new DatabricksSparkPythonActivityTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pythonFile".equals(fieldName)) {
                    deserializedDatabricksSparkPythonActivityTypeProperties.pythonFile = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedDatabricksSparkPythonActivityTypeProperties.parameters = parameters = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("libraries".equals(fieldName)) {
                    List libraries;
                    deserializedDatabricksSparkPythonActivityTypeProperties.libraries = libraries = reader.readArray(reader1 -> reader1.readMap(reader2 -> reader2.readUntyped()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabricksSparkPythonActivityTypeProperties;
        });
    }
}

