/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BlobEventTypes;
import java.io.IOException;
import java.util.List;

public final class BlobEventsTriggerTypeProperties
implements JsonSerializable<BlobEventsTriggerTypeProperties> {
    private String blobPathBeginsWith;
    private String blobPathEndsWith;
    private Boolean ignoreEmptyBlobs;
    private List<BlobEventTypes> events;
    private String scope;
    private static final ClientLogger LOGGER = new ClientLogger(BlobEventsTriggerTypeProperties.class);

    public String blobPathBeginsWith() {
        return this.blobPathBeginsWith;
    }

    public BlobEventsTriggerTypeProperties withBlobPathBeginsWith(String blobPathBeginsWith) {
        this.blobPathBeginsWith = blobPathBeginsWith;
        return this;
    }

    public String blobPathEndsWith() {
        return this.blobPathEndsWith;
    }

    public BlobEventsTriggerTypeProperties withBlobPathEndsWith(String blobPathEndsWith) {
        this.blobPathEndsWith = blobPathEndsWith;
        return this;
    }

    public Boolean ignoreEmptyBlobs() {
        return this.ignoreEmptyBlobs;
    }

    public BlobEventsTriggerTypeProperties withIgnoreEmptyBlobs(Boolean ignoreEmptyBlobs) {
        this.ignoreEmptyBlobs = ignoreEmptyBlobs;
        return this;
    }

    public List<BlobEventTypes> events() {
        return this.events;
    }

    public BlobEventsTriggerTypeProperties withEvents(List<BlobEventTypes> events) {
        this.events = events;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public BlobEventsTriggerTypeProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public void validate() {
        if (this.events() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property events in model BlobEventsTriggerTypeProperties"));
        }
        if (this.scope() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scope in model BlobEventsTriggerTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("events", this.events, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("blobPathBeginsWith", this.blobPathBeginsWith);
        jsonWriter.writeStringField("blobPathEndsWith", this.blobPathEndsWith);
        jsonWriter.writeBooleanField("ignoreEmptyBlobs", this.ignoreEmptyBlobs);
        return jsonWriter.writeEndObject();
    }

    public static BlobEventsTriggerTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BlobEventsTriggerTypeProperties)jsonReader.readObject(reader -> {
            BlobEventsTriggerTypeProperties deserializedBlobEventsTriggerTypeProperties = new BlobEventsTriggerTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("events".equals(fieldName)) {
                    List events;
                    deserializedBlobEventsTriggerTypeProperties.events = events = reader.readArray(reader1 -> BlobEventTypes.fromString(reader1.getString()));
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedBlobEventsTriggerTypeProperties.scope = reader.getString();
                    continue;
                }
                if ("blobPathBeginsWith".equals(fieldName)) {
                    deserializedBlobEventsTriggerTypeProperties.blobPathBeginsWith = reader.getString();
                    continue;
                }
                if ("blobPathEndsWith".equals(fieldName)) {
                    deserializedBlobEventsTriggerTypeProperties.blobPathEndsWith = reader.getString();
                    continue;
                }
                if ("ignoreEmptyBlobs".equals(fieldName)) {
                    deserializedBlobEventsTriggerTypeProperties.ignoreEmptyBlobs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobEventsTriggerTypeProperties;
        });
    }
}

