/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureSearchLinkedServiceTypeProperties
implements JsonSerializable<AzureSearchLinkedServiceTypeProperties> {
    private Object url;
    private SecretBase key;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureSearchLinkedServiceTypeProperties.class);

    public Object url() {
        return this.url;
    }

    public AzureSearchLinkedServiceTypeProperties withUrl(Object url) {
        this.url = url;
        return this;
    }

    public SecretBase key() {
        return this.key;
    }

    public AzureSearchLinkedServiceTypeProperties withKey(SecretBase key) {
        this.key = key;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureSearchLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model AzureSearchLinkedServiceTypeProperties"));
        }
        if (this.key() != null) {
            this.key().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url);
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AzureSearchLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSearchLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureSearchLinkedServiceTypeProperties deserializedAzureSearchLinkedServiceTypeProperties = new AzureSearchLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedAzureSearchLinkedServiceTypeProperties.url = reader.readUntyped();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedAzureSearchLinkedServiceTypeProperties.key = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureSearchLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureSearchLinkedServiceTypeProperties;
        });
    }
}

