/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.AzureStorageAuthenticationType;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureBlobStorageLinkedServiceTypeProperties
implements JsonSerializable<AzureBlobStorageLinkedServiceTypeProperties> {
    private Object connectionString;
    private AzureKeyVaultSecretReference accountKey;
    private Object sasUri;
    private AzureKeyVaultSecretReference sasToken;
    private Object serviceEndpoint;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object azureCloudType;
    private Object accountKind;
    private String encryptedCredential;
    private CredentialReference credential;
    private AzureStorageAuthenticationType authenticationType;
    private Object containerUri;

    public Object connectionString() {
        return this.connectionString;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference accountKey() {
        return this.accountKey;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withAccountKey(AzureKeyVaultSecretReference accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object sasUri() {
        return this.sasUri;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public AzureKeyVaultSecretReference sasToken() {
        return this.sasToken;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withSasToken(AzureKeyVaultSecretReference sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public Object serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withServiceEndpoint(Object serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object azureCloudType() {
        return this.azureCloudType;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withAzureCloudType(Object azureCloudType) {
        this.azureCloudType = azureCloudType;
        return this;
    }

    public Object accountKind() {
        return this.accountKind;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withAccountKind(Object accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public AzureStorageAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withAuthenticationType(AzureStorageAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object containerUri() {
        return this.containerUri;
    }

    public AzureBlobStorageLinkedServiceTypeProperties withContainerUri(Object containerUri) {
        this.containerUri = containerUri;
        return this;
    }

    public void validate() {
        if (this.accountKey() != null) {
            this.accountKey().validate();
        }
        if (this.sasToken() != null) {
            this.sasToken().validate();
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
        jsonWriter.writeUntypedField("sasUri", this.sasUri);
        jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
        jsonWriter.writeUntypedField("serviceEndpoint", this.serviceEndpoint);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        jsonWriter.writeUntypedField("azureCloudType", this.azureCloudType);
        jsonWriter.writeUntypedField("accountKind", this.accountKind);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        jsonWriter.writeUntypedField("containerUri", this.containerUri);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureBlobStorageLinkedServiceTypeProperties deserializedAzureBlobStorageLinkedServiceTypeProperties = new AzureBlobStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.accountKey = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("sasUri".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.sasUri = reader.readUntyped();
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.sasToken = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("serviceEndpoint".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.serviceEndpoint = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("azureCloudType".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.azureCloudType = reader.readUntyped();
                    continue;
                }
                if ("accountKind".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.accountKind = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.authenticationType = AzureStorageAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("containerUri".equals(fieldName)) {
                    deserializedAzureBlobStorageLinkedServiceTypeProperties.containerUri = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlobStorageLinkedServiceTypeProperties;
        });
    }
}

