/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SubscriptionTerm
implements JsonSerializable<SubscriptionTerm> {
    private String termUnit;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;

    private SubscriptionTerm() {
    }

    public String termUnit() {
        return this.termUnit;
    }

    public OffsetDateTime startDate() {
        return this.startDate;
    }

    public OffsetDateTime endDate() {
        return this.endDate;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("termUnit", this.termUnit);
        jsonWriter.writeStringField("startDate", this.startDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDate));
        jsonWriter.writeStringField("endDate", this.endDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDate));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionTerm fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionTerm)jsonReader.readObject(reader -> {
            SubscriptionTerm deserializedSubscriptionTerm = new SubscriptionTerm();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("termUnit".equals(fieldName)) {
                    deserializedSubscriptionTerm.termUnit = reader.getString();
                    continue;
                }
                if ("startDate".equals(fieldName)) {
                    deserializedSubscriptionTerm.startDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDate".equals(fieldName)) {
                    deserializedSubscriptionTerm.endDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionTerm;
        });
    }
}

