/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.StartTlsPolicy;
import java.io.IOException;

public final class Smtp
implements JsonSerializable<Smtp> {
    private Boolean enabled;
    private String host;
    private String user;
    private String password;
    private String fromAddress;
    private String fromName;
    private StartTlsPolicy startTlsPolicy;
    private Boolean skipVerify;

    public Boolean enabled() {
        return this.enabled;
    }

    public Smtp withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String host() {
        return this.host;
    }

    public Smtp withHost(String host) {
        this.host = host;
        return this;
    }

    public String user() {
        return this.user;
    }

    public Smtp withUser(String user) {
        this.user = user;
        return this;
    }

    public String password() {
        return this.password;
    }

    public Smtp withPassword(String password) {
        this.password = password;
        return this;
    }

    public String fromAddress() {
        return this.fromAddress;
    }

    public Smtp withFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    public String fromName() {
        return this.fromName;
    }

    public Smtp withFromName(String fromName) {
        this.fromName = fromName;
        return this;
    }

    public StartTlsPolicy startTlsPolicy() {
        return this.startTlsPolicy;
    }

    public Smtp withStartTlsPolicy(StartTlsPolicy startTlsPolicy) {
        this.startTlsPolicy = startTlsPolicy;
        return this;
    }

    public Boolean skipVerify() {
        return this.skipVerify;
    }

    public Smtp withSkipVerify(Boolean skipVerify) {
        this.skipVerify = skipVerify;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("fromAddress", this.fromAddress);
        jsonWriter.writeStringField("fromName", this.fromName);
        jsonWriter.writeStringField("startTLSPolicy", this.startTlsPolicy == null ? null : this.startTlsPolicy.toString());
        jsonWriter.writeBooleanField("skipVerify", this.skipVerify);
        return jsonWriter.writeEndObject();
    }

    public static Smtp fromJson(JsonReader jsonReader) throws IOException {
        return (Smtp)jsonReader.readObject(reader -> {
            Smtp deserializedSmtp = new Smtp();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedSmtp.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedSmtp.host = reader.getString();
                    continue;
                }
                if ("user".equals(fieldName)) {
                    deserializedSmtp.user = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSmtp.password = reader.getString();
                    continue;
                }
                if ("fromAddress".equals(fieldName)) {
                    deserializedSmtp.fromAddress = reader.getString();
                    continue;
                }
                if ("fromName".equals(fieldName)) {
                    deserializedSmtp.fromName = reader.getString();
                    continue;
                }
                if ("startTLSPolicy".equals(fieldName)) {
                    deserializedSmtp.startTlsPolicy = StartTlsPolicy.fromString(reader.getString());
                    continue;
                }
                if ("skipVerify".equals(fieldName)) {
                    deserializedSmtp.skipVerify = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSmtp;
        });
    }
}

