/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.Security;
import com.azure.resourcemanager.dashboard.models.Smtp;
import com.azure.resourcemanager.dashboard.models.Snapshots;
import com.azure.resourcemanager.dashboard.models.UnifiedAlertingScreenshots;
import com.azure.resourcemanager.dashboard.models.Users;
import java.io.IOException;

public final class GrafanaConfigurations
implements JsonSerializable<GrafanaConfigurations> {
    private Smtp smtp;
    private Snapshots snapshots;
    private Users users;
    private Security security;
    private UnifiedAlertingScreenshots unifiedAlertingScreenshots;

    public Smtp smtp() {
        return this.smtp;
    }

    public GrafanaConfigurations withSmtp(Smtp smtp) {
        this.smtp = smtp;
        return this;
    }

    public Snapshots snapshots() {
        return this.snapshots;
    }

    public GrafanaConfigurations withSnapshots(Snapshots snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public Users users() {
        return this.users;
    }

    public GrafanaConfigurations withUsers(Users users) {
        this.users = users;
        return this;
    }

    public Security security() {
        return this.security;
    }

    public GrafanaConfigurations withSecurity(Security security) {
        this.security = security;
        return this;
    }

    public UnifiedAlertingScreenshots unifiedAlertingScreenshots() {
        return this.unifiedAlertingScreenshots;
    }

    public GrafanaConfigurations withUnifiedAlertingScreenshots(UnifiedAlertingScreenshots unifiedAlertingScreenshots) {
        this.unifiedAlertingScreenshots = unifiedAlertingScreenshots;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("smtp", (JsonSerializable)this.smtp);
        jsonWriter.writeJsonField("snapshots", (JsonSerializable)this.snapshots);
        jsonWriter.writeJsonField("users", (JsonSerializable)this.users);
        jsonWriter.writeJsonField("security", (JsonSerializable)this.security);
        jsonWriter.writeJsonField("unifiedAlertingScreenshots", (JsonSerializable)this.unifiedAlertingScreenshots);
        return jsonWriter.writeEndObject();
    }

    public static GrafanaConfigurations fromJson(JsonReader jsonReader) throws IOException {
        return (GrafanaConfigurations)jsonReader.readObject(reader -> {
            GrafanaConfigurations deserializedGrafanaConfigurations = new GrafanaConfigurations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("smtp".equals(fieldName)) {
                    deserializedGrafanaConfigurations.smtp = Smtp.fromJson(reader);
                    continue;
                }
                if ("snapshots".equals(fieldName)) {
                    deserializedGrafanaConfigurations.snapshots = Snapshots.fromJson(reader);
                    continue;
                }
                if ("users".equals(fieldName)) {
                    deserializedGrafanaConfigurations.users = Users.fromJson(reader);
                    continue;
                }
                if ("security".equals(fieldName)) {
                    deserializedGrafanaConfigurations.security = Security.fromJson(reader);
                    continue;
                }
                if ("unifiedAlertingScreenshots".equals(fieldName)) {
                    deserializedGrafanaConfigurations.unifiedAlertingScreenshots = UnifiedAlertingScreenshots.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGrafanaConfigurations;
        });
    }
}

