/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dashboard.fluent.GrafanasClient;
import com.azure.resourcemanager.dashboard.fluent.models.EnterpriseDetailsInner;
import com.azure.resourcemanager.dashboard.fluent.models.GrafanaAvailablePluginListResponseInner;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedGrafanaInner;
import com.azure.resourcemanager.dashboard.implementation.DashboardManagementClientImpl;
import com.azure.resourcemanager.dashboard.implementation.models.ManagedGrafanaListResponse;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GrafanasClientImpl
implements GrafanasClient {
    private final GrafanasService service;
    private final DashboardManagementClientImpl client;

    GrafanasClientImpl(DashboardManagementClientImpl client) {
        this.service = (GrafanasService)RestProxy.create(GrafanasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedGrafanaInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedGrafanaInner> getByResourceGroupAsync(String resourceGroupName, String workspaceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, workspaceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedGrafanaInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedGrafanaInner> getByResourceGroupWithResponse(String resourceGroupName, String workspaceName, Context context) {
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedGrafanaInner getByResourceGroup(String resourceGroupName, String workspaceName) {
        return (ManagedGrafanaInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, workspaceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", "application/json", requestBodyParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", "application/json", requestBodyParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", "application/json", requestBodyParameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedGrafanaInner>, ManagedGrafanaInner> beginCreateAsync(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, workspaceName, requestBodyParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedGrafanaInner.class), (Type)((Object)ManagedGrafanaInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedGrafanaInner>, ManagedGrafanaInner> beginCreate(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, workspaceName, requestBodyParameters);
        return this.client.getLroResult(response, (Type)((Object)ManagedGrafanaInner.class), (Type)((Object)ManagedGrafanaInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedGrafanaInner>, ManagedGrafanaInner> beginCreate(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, workspaceName, requestBodyParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ManagedGrafanaInner.class), (Type)((Object)ManagedGrafanaInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedGrafanaInner> createAsync(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters) {
        return this.beginCreateAsync(resourceGroupName, workspaceName, requestBodyParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedGrafanaInner create(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters) {
        return (ManagedGrafanaInner)((Object)this.beginCreate(resourceGroupName, workspaceName, requestBodyParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedGrafanaInner create(String resourceGroupName, String workspaceName, ManagedGrafanaInner requestBodyParameters, Context context) {
        return (ManagedGrafanaInner)((Object)this.beginCreate(resourceGroupName, workspaceName, requestBodyParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", "application/json", requestBodyParameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", "application/json", requestBodyParameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", "application/json", requestBodyParameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ManagedGrafanaInner>, ManagedGrafanaInner> beginUpdateAsync(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, workspaceName, requestBodyParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ManagedGrafanaInner.class), (Type)((Object)ManagedGrafanaInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedGrafanaInner>, ManagedGrafanaInner> beginUpdate(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, workspaceName, requestBodyParameters);
        return this.client.getLroResult(response, (Type)((Object)ManagedGrafanaInner.class), (Type)((Object)ManagedGrafanaInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ManagedGrafanaInner>, ManagedGrafanaInner> beginUpdate(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, workspaceName, requestBodyParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ManagedGrafanaInner.class), (Type)((Object)ManagedGrafanaInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedGrafanaInner> updateAsync(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters) {
        return this.beginUpdateAsync(resourceGroupName, workspaceName, requestBodyParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedGrafanaInner update(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters) {
        return (ManagedGrafanaInner)((Object)this.beginUpdate(resourceGroupName, workspaceName, requestBodyParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedGrafanaInner update(String resourceGroupName, String workspaceName, ManagedGrafanaUpdateParameters requestBodyParameters, Context context) {
        return (ManagedGrafanaInner)((Object)this.beginUpdate(resourceGroupName, workspaceName, requestBodyParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String workspaceName) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String workspaceName) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String workspaceName, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String workspaceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, workspaceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String workspaceName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, workspaceName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String workspaceName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, workspaceName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String workspaceName) {
        return this.beginDeleteAsync(resourceGroupName, workspaceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName) {
        this.beginDelete(resourceGroupName, workspaceName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String workspaceName, Context context) {
        this.beginDelete(resourceGroupName, workspaceName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedGrafanaInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedGrafanaInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listByResourceGroupSinglePage(String resourceGroupName) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedGrafanaInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedGrafanaInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedGrafanaInner>> listSinglePageAsync() {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedGrafanaInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listSinglePage() {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listSinglePage(Context context) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedGrafanaInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedGrafanaInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EnterpriseDetailsInner>> checkEnterpriseDetailsWithResponseAsync(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkEnterpriseDetails(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EnterpriseDetailsInner> checkEnterpriseDetailsAsync(String resourceGroupName, String workspaceName) {
        return this.checkEnterpriseDetailsWithResponseAsync(resourceGroupName, workspaceName).flatMap(res -> Mono.justOrEmpty((Object)((EnterpriseDetailsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EnterpriseDetailsInner> checkEnterpriseDetailsWithResponse(String resourceGroupName, String workspaceName, Context context) {
        String accept = "application/json";
        return this.service.checkEnterpriseDetailsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EnterpriseDetailsInner checkEnterpriseDetails(String resourceGroupName, String workspaceName) {
        return (EnterpriseDetailsInner)this.checkEnterpriseDetailsWithResponse(resourceGroupName, workspaceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GrafanaAvailablePluginListResponseInner>> fetchAvailablePluginsWithResponseAsync(String resourceGroupName, String workspaceName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.fetchAvailablePlugins(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GrafanaAvailablePluginListResponseInner> fetchAvailablePluginsAsync(String resourceGroupName, String workspaceName) {
        return this.fetchAvailablePluginsWithResponseAsync(resourceGroupName, workspaceName).flatMap(res -> Mono.justOrEmpty((Object)((GrafanaAvailablePluginListResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GrafanaAvailablePluginListResponseInner> fetchAvailablePluginsWithResponse(String resourceGroupName, String workspaceName, Context context) {
        String accept = "application/json";
        return this.service.fetchAvailablePluginsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, workspaceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GrafanaAvailablePluginListResponseInner fetchAvailablePlugins(String resourceGroupName, String workspaceName) {
        return (GrafanaAvailablePluginListResponseInner)this.fetchAvailablePluginsWithResponse(resourceGroupName, workspaceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedGrafanaInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listByResourceGroupNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedGrafanaInner>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ManagedGrafanaInner> listNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<ManagedGrafanaListResponse> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedGrafanaListResponse)res.getValue()).value(), ((ManagedGrafanaListResponse)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DashboardManagementClientGrafanas")
    public static interface GrafanasService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedGrafanaInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedGrafanaInner> getByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedGrafanaInner var8, Context var9);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedGrafanaInner var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedGrafanaUpdateParameters var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ManagedGrafanaUpdateParameters var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedGrafanaListResponse>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedGrafanaListResponse> listByResourceGroupSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Dashboard/grafana")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedGrafanaListResponse>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Dashboard/grafana")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedGrafanaListResponse> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/checkEnterpriseDetails")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EnterpriseDetailsInner>> checkEnterpriseDetails(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/checkEnterpriseDetails")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<EnterpriseDetailsInner> checkEnterpriseDetailsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/fetchAvailablePlugins")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GrafanaAvailablePluginListResponseInner>> fetchAvailablePlugins(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Dashboard/grafana/{workspaceName}/fetchAvailablePlugins")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GrafanaAvailablePluginListResponseInner> fetchAvailablePluginsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="workspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedGrafanaListResponse>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedGrafanaListResponse> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedGrafanaListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ManagedGrafanaListResponse> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

