/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.SubscriptionTerm;
import java.io.IOException;

public final class SaasSubscriptionDetails
implements JsonSerializable<SaasSubscriptionDetails> {
    private String planId;
    private String offerId;
    private String publisherId;
    private SubscriptionTerm term;

    private SaasSubscriptionDetails() {
    }

    public String planId() {
        return this.planId;
    }

    public String offerId() {
        return this.offerId;
    }

    public String publisherId() {
        return this.publisherId;
    }

    public SubscriptionTerm term() {
        return this.term;
    }

    public void validate() {
        if (this.term() != null) {
            this.term().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("planId", this.planId);
        jsonWriter.writeStringField("offerId", this.offerId);
        jsonWriter.writeStringField("publisherId", this.publisherId);
        jsonWriter.writeJsonField("term", (JsonSerializable)this.term);
        return jsonWriter.writeEndObject();
    }

    public static SaasSubscriptionDetails fromJson(JsonReader jsonReader) throws IOException {
        return (SaasSubscriptionDetails)jsonReader.readObject(reader -> {
            SaasSubscriptionDetails deserializedSaasSubscriptionDetails = new SaasSubscriptionDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("planId".equals(fieldName)) {
                    deserializedSaasSubscriptionDetails.planId = reader.getString();
                    continue;
                }
                if ("offerId".equals(fieldName)) {
                    deserializedSaasSubscriptionDetails.offerId = reader.getString();
                    continue;
                }
                if ("publisherId".equals(fieldName)) {
                    deserializedSaasSubscriptionDetails.publisherId = reader.getString();
                    continue;
                }
                if ("term".equals(fieldName)) {
                    deserializedSaasSubscriptionDetails.term = SubscriptionTerm.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSaasSubscriptionDetails;
        });
    }
}

